/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.updater;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatMessageComponent;
import powercrystals.core.CoreCore;
import powercrystals.core.updater.IUpdateableMod;
import powercrystals.core.updater.UpdateCheckThread;

public class UpdateManager
implements IScheduledTickHandler {
    private boolean _notificationDisplayed;
    private IUpdateableMod _mod;
    private UpdateCheckThread _updateThread;

    public UpdateManager(IUpdateableMod iUpdateableMod) {
        this(iUpdateableMod, null);
    }

    public UpdateManager(IUpdateableMod iUpdateableMod, String string) {
        this._mod = iUpdateableMod;
        this._updateThread = new UpdateCheckThread(iUpdateableMod, string);
        if (CoreCore.doUpdateCheck.getBoolean(true)) {
            this._updateThread.start();
        }
    }

    public void tickStart(EnumSet<TickType> enumSet, Object ... objectArray) {
        if (!this._notificationDisplayed && this._updateThread.checkComplete()) {
            this._notificationDisplayed = true;
            if (this._updateThread.newVersionAvailable()) {
                EntityPlayer entityPlayer = (EntityPlayer)objectArray[0];
                entityPlayer.func_70006_a(new ChatMessageComponent().func_111079_a("[" + this._mod.getModName() + "] A new version is available: " + this._updateThread.newVersion().modVersion().toString()));
                entityPlayer.func_70006_a(new ChatMessageComponent().func_111079_a(this._updateThread.newVersion().description()));
            }
        }
    }

    public void tickEnd(EnumSet<TickType> enumSet, Object ... objectArray) {
    }

    public EnumSet<TickType> ticks() {
        if (this._notificationDisplayed) {
            return EnumSet.noneOf(TickType.class);
        }
        return EnumSet.of(TickType.PLAYER);
    }

    public String getLabel() {
        return this._mod.getModId() + ".version";
    }

    public int nextTickSpacing() {
        if (!this._notificationDisplayed) {
            return 400;
        }
        return 72000;
    }
}

