/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.gui.controls;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import powercrystals.core.gui.controls.Button;

public abstract class ButtonOption
extends Button {
    private Map<Integer, String> _values = new HashMap<Integer, String>();
    private int _currentValue = 0;
    private int _maxValue;

    public ButtonOption(GuiContainer guiContainer, int n, int n2, int n3, int n4) {
        super(guiContainer, n, n2, n3, n4, "");
    }

    public void setValue(int n, String string) {
        this._values.put(n, string);
        if (n > this._maxValue) {
            this._maxValue = n;
        }
    }

    @Override
    public void onClick() {
        int n = this._currentValue + 1;
        if (n > this._maxValue) {
            n = 0;
        }
        while (this._values.get(n) == null) {
            ++n;
        }
        this.setSelectedIndex(n);
    }

    @Override
    public void onRightClick() {
        int n = this._currentValue - 1;
        while (this._values.get(n) == null) {
            if (--n >= 0) continue;
            n = this._maxValue;
        }
        this.setSelectedIndex(n);
    }

    public int getSelectedIndex() {
        return this._currentValue;
    }

    public void setSelectedIndex(int n) {
        this._currentValue = n;
        this.setText(this._values.get(this._currentValue));
        this.onValueChanged(this._currentValue, this._values.get(this._currentValue));
    }

    public String getValue() {
        return this._values.get(this._currentValue);
    }

    public abstract void onValueChanged(int var1, String var2);
}

