/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import powercrystals.core.block.BlockFluidRoot;

public class BlockFluidClassic
extends BlockFluidRoot {
    protected boolean[] isOptimalFlowDirection = new boolean[4];
    protected int[] flowCost = new int[4];

    public BlockFluidClassic(int n, Material material) {
        super(n, material);
    }

    @Override
    public boolean canDisplace(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        int n4 = iBlockAccess.func_72798_a(n, n2, n3);
        if (n4 == 0) {
            return true;
        }
        if (n4 == this.field_71990_ca) {
            return false;
        }
        if (displacementIds.containsKey(n4)) {
            return (Boolean)displacementIds.get(n4);
        }
        Material material = Block.field_71973_m[n4].field_72018_cp;
        return !material.func_76230_c() && material != Material.field_76244_g && material != Material.field_76256_h && material != Material.field_76237_B;
    }

    @Override
    public boolean displaceIfPossible(World world, int n, int n2, int n3) {
        int n4 = world.func_72798_a(n, n2, n3);
        if (n4 == 0) {
            return true;
        }
        if (n4 == this.field_71990_ca) {
            return false;
        }
        if (displacementIds.containsKey(n4)) {
            if (((Boolean)displacementIds.get(n4)).booleanValue()) {
                Block.field_71973_m[n4].func_71897_c(world, n, n2, n3, world.func_72805_g(n, n2, n3), 0);
                return true;
            }
            return false;
        }
        Material material = Block.field_71973_m[n4].field_72018_cp;
        if (material.func_76230_c() || material == Material.field_76244_g || material == Material.field_76256_h || material == Material.field_76237_B) {
            return false;
        }
        Block.field_71973_m[n4].func_71897_c(world, n, n2, n3, world.func_72805_g(n, n2, n3), 0);
        return true;
    }

    public boolean isFlowingVertically(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return iBlockAccess.func_72798_a(n, n2 + this.densityDir, n3) == this.field_71990_ca || iBlockAccess.func_72798_a(n, n2, n3) == this.field_71990_ca && this.canFlowInto(iBlockAccess, n, n2 + this.densityDir, n3);
    }

    public boolean isSourceBlock(World world, int n, int n2, int n3) {
        return world.func_72798_a(n, n2, n3) == this.field_71990_ca && world.func_72805_g(n, n2, n3) + 1 == this.quantaPerBlock;
    }

    protected void updateFlowLevel(World world, int n, int n2, int n3, int n4) {
    }

    public void func_71860_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        world.func_72832_d(n, n2, n3, this.field_71990_ca, this.quantaPerBlock - 1, 3);
    }

    public void func_71847_b(World world, int n, int n2, int n3, Random random) {
        int n4;
        int n5 = world.func_72805_g(n, n2, n3) + 1;
        int n6 = -101;
        if (n5 < this.quantaPerBlock) {
            n4 = n2 - this.densityDir;
            if (world.func_72798_a(n, n4, n3) == this.field_71990_ca || world.func_72798_a(n - 1, n4, n3) == this.field_71990_ca || world.func_72798_a(n + 1, n4, n3) == this.field_71990_ca || world.func_72798_a(n, n4, n3 - 1) == this.field_71990_ca || world.func_72798_a(n, n4, n3 + 1) == this.field_71990_ca) {
                n6 = this.quantaPerBlock - 1;
            } else {
                int n7 = -100;
                n7 = this.getLargerQuanta((IBlockAccess)world, n - 1, n2, n3, n7);
                n7 = this.getLargerQuanta((IBlockAccess)world, n + 1, n2, n3, n7);
                n7 = this.getLargerQuanta((IBlockAccess)world, n, n2, n3 - 1, n7);
                n7 = this.getLargerQuanta((IBlockAccess)world, n, n2, n3 + 1, n7);
                n6 = n7 - 1;
            }
            if (n6 != n5) {
                n5 = n6;
                if (n6 <= 0) {
                    world.func_94571_i(n, n2, n3);
                } else {
                    world.func_72921_c(n, n2, n3, n6 - 1, 3);
                    world.func_72836_a(n, n2, n3, this.field_71990_ca, this.tickRate);
                    world.func_72898_h(n, n2, n3, this.field_71990_ca);
                }
            }
        }
        if (this.canDisplace((IBlockAccess)world, n, n2 + this.densityDir, n3)) {
            this.flowIntoBlock(world, n, n2 + this.densityDir, n3, this.quantaPerBlock - 2);
            return;
        }
        n4 = n5 - 2;
        if (n4 < 0) {
            return;
        }
        if (this.isSourceBlock(world, n, n2, n3) || !this.isFlowingVertically((IBlockAccess)world, n, n2, n3)) {
            boolean[] blArray;
            if (world.func_72798_a(n, n2 - this.densityDir, n3) == this.field_71990_ca) {
                n4 = this.quantaPerBlock - 2;
            }
            if ((blArray = this.getOptimalFlowDirections(world, n, n2, n3))[0]) {
                this.flowIntoBlock(world, n - 1, n2, n3, n4);
            }
            if (blArray[1]) {
                this.flowIntoBlock(world, n + 1, n2, n3, n4);
            }
            if (blArray[2]) {
                this.flowIntoBlock(world, n, n2, n3 - 1, n4);
            }
            if (blArray[3]) {
                this.flowIntoBlock(world, n, n2, n3 + 1, n4);
            }
        }
    }

    protected boolean[] getOptimalFlowDirections(World world, int n, int n2, int n3) {
        int n4;
        int n5;
        for (n5 = 0; n5 < 4; ++n5) {
            this.flowCost[n5] = 1000;
            n4 = n;
            int n6 = n2;
            int n7 = n3;
            switch (n5) {
                case 0: {
                    --n4;
                    break;
                }
                case 1: {
                    ++n4;
                    break;
                }
                case 2: {
                    --n7;
                    break;
                }
                case 3: {
                    ++n7;
                }
            }
            if (!this.canFlowInto((IBlockAccess)world, n4, n6, n7) || this.isSourceBlock(world, n4, n6, n7)) continue;
            this.flowCost[n5] = this.canFlowInto((IBlockAccess)world, n4, n6 + this.densityDir, n7) ? 0 : this.calculateFlowCost(world, n4, n6, n7, 1, n5);
        }
        n5 = this.flowCost[0];
        for (n4 = 1; n4 < 4; ++n4) {
            if (this.flowCost[n4] >= n5) continue;
            n5 = this.flowCost[n4];
        }
        for (n4 = 0; n4 < 4; ++n4) {
            this.isOptimalFlowDirection[n4] = this.flowCost[n4] == n5;
        }
        return this.isOptimalFlowDirection;
    }

    protected int calculateFlowCost(World world, int n, int n2, int n3, int n4, int n5) {
        int n6 = 1000;
        for (int i = 0; i < 4; ++i) {
            int n7;
            if (i == 0 && n5 == 1 || i == 1 && n5 == 0 || i == 2 && n5 == 3 || i == 3 && n5 == 2) continue;
            int n8 = n;
            int n9 = n2;
            int n10 = n3;
            switch (i) {
                case 0: {
                    --n8;
                    break;
                }
                case 1: {
                    ++n8;
                    break;
                }
                case 2: {
                    --n10;
                    break;
                }
                case 3: {
                    ++n10;
                }
            }
            if (!this.canFlowInto((IBlockAccess)world, n8, n9, n10) || this.isSourceBlock(world, n8, n9, n10)) continue;
            if (this.canFlowInto((IBlockAccess)world, n8, n9 + this.densityDir, n10)) {
                return n4;
            }
            if (n4 >= 4 || (n7 = this.calculateFlowCost(world, n8, n9, n10, n4 + 1, i)) >= n6) continue;
            n6 = n7;
        }
        return n6;
    }

    protected void flowIntoBlock(World world, int n, int n2, int n3, int n4) {
        if (this.displaceIfPossible(world, n, n2, n3)) {
            world.func_72832_d(n, n2, n3, this.field_71990_ca, n4, 3);
        }
    }

    protected boolean canFlowInto(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        int n4 = iBlockAccess.func_72798_a(n, n2, n3);
        if (n4 == 0) {
            return true;
        }
        if (n4 == this.field_71990_ca) {
            return true;
        }
        if (displacementIds.containsKey(n4)) {
            return (Boolean)displacementIds.get(n4);
        }
        Material material = Block.field_71973_m[n4].field_72018_cp;
        return !material.func_76230_c() && material != Material.field_76244_g && material != Material.field_76256_h && material != Material.field_76237_B;
    }

    protected int getLargerQuanta(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        int n5 = this.getQuantaValue(iBlockAccess, n, n2, n3);
        if (n5 <= 0) {
            return n4;
        }
        return n5 >= n4 ? n5 : n4;
    }
}

