/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.forge;

import codechicken.nei.forge.IContainerTooltipHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.IOptionUpdateCallback;
import mods.neiplugins.common.NEIProxyClient;
import mods.neiplugins.common.TooltipCache;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryTooltipHandler
implements IContainerTooltipHandler,
IOptionUpdateCallback {
    public static TooltipCache tooltipCache = new TooltipCache(true);
    public static boolean isEnabled = false;

    public List<String> handleTooltipFirst(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
        return currenttip;
    }

    public static void resetCache() {
        int mainOreID;
        ArrayList<String> tooltip;
        int oreID;
        NEIPlugins.logFine("OreDictionaryTooltipHandler.resetCache() start", new Object[0]);
        tooltipCache.clear();
        Object[] oreNames = OreDictionary.getOreNames();
        Arrays.sort(oreNames);
        for (Object oreName : oreNames) {
            oreID = OreDictionary.getOreID((String)oreName);
            for (ItemStack ore : OreDictionary.getOres((String)oreName)) {
                if (ore.func_77960_j() != Short.MAX_VALUE) continue;
                tooltip = new ArrayList<String>();
                tooltipCache.addCachedTooltip(ore, tooltip);
                mainOreID = OreDictionary.getOreID((ItemStack)ore);
                if (mainOreID == oreID) {
                    tooltip.add("\u00a77" + (String)oreName);
                } else {
                    tooltip.add("\u00a78" + (String)oreName);
                }
                tooltipCache.put(ore, tooltip);
            }
        }
        for (Object oreName : oreNames) {
            oreID = OreDictionary.getOreID((String)oreName);
            for (ItemStack ore : OreDictionary.getOres((String)oreName)) {
                if (ore.func_77960_j() == Short.MAX_VALUE) continue;
                tooltip = new ArrayList();
                tooltipCache.addCachedTooltip(ore, tooltip);
                mainOreID = OreDictionary.getOreID((ItemStack)ore);
                if (mainOreID == oreID) {
                    for (int i = 1; i < tooltip.size(); ++i) {
                        if (!((String)tooltip.get(i)).startsWith("\u00a77") || ((String)tooltip.get(i)).equals("\u00a77" + (String)oreName)) continue;
                        tooltip.add(i, "\u00a78" + ((String)tooltip.remove(i)).substring(2));
                    }
                    tooltip.add("\u00a77" + (String)oreName);
                } else {
                    tooltip.add("\u00a78" + (String)oreName);
                }
                tooltipCache.put(ore, tooltip);
            }
        }
        NEIPlugins.logFine("OreDictionaryTooltipHandler.resetCache() end", new Object[0]);
    }

    public List<String> handleItemTooltip(GuiContainer gui, ItemStack stack, List<String> currenttip) {
        if (gui == null && !NEIProxyClient.canModifyTooltip()) {
            return currenttip;
        }
        if (stack == null || !isEnabled) {
            return currenttip;
        }
        if (gui != null && tooltipCache.haveWildcardTooltip(stack)) {
            currenttip.add("\u00a77Ore Dictionary names:");
        }
        if (tooltipCache.addCachedWildcardTooltip(stack, currenttip)) {
            return currenttip;
        }
        return currenttip;
    }

    @Override
    public void onOptionUpdate() {
        isEnabled = NEIProxyClient.getBooleanSetting("neiplugins.developer.showOreDictionaryNames", false);
    }
}

