/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.forestry;

import codechicken.nei.NEIClientUtils;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.IBackpackDefinition;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.ItemStackComparator;
import mods.neiplugins.lists.GuiButtonList;
import mods.neiplugins.lists.GuiList;
import mods.neiplugins.lists.IListElement;
import mods.neiplugins.lists.MultipleStackListElement;
import mods.neiplugins.lists.SimpleListActiveElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class GuiBackpackContentlist
extends GuiList {
    protected GuiBackpackContentlist(GuiContainer prevgui, String title, ArrayList<? extends IListElement> list) {
        super(prevgui, title, list);
    }

    @Override
    public int getElementsOffset() {
        return 20;
    }

    @Override
    public int getElementHeight() {
        return 16;
    }

    @Override
    protected void drawBackground(int index, boolean empty, boolean hovered) {
    }

    public static boolean showList(String title) {
        ArrayList<ListElement1> list = new ArrayList<ListElement1>();
        for (String backpackID : new TreeSet(BackpackManager.definitions.keySet())) {
            boolean active = false;
            try {
                active = !((IBackpackDefinition)BackpackManager.definitions.get(backpackID)).getValidItems(null).isEmpty();
            }
            catch (Exception ex) {
                NEIPlugins.logWarning("Error in GuiBackpackContentlist: {0}", ex);
            }
            list.add(new ListElement1(((IBackpackDefinition)BackpackManager.definitions.get(backpackID)).getName(), backpackID, active));
        }
        if (list.isEmpty()) {
            return false;
        }
        return GuiButtonList.showList(title, list);
    }

    public static boolean showBackpackList(String backpackID) {
        if (!BackpackManager.definitions.containsKey(backpackID)) {
            return false;
        }
        ArrayList<MultipleStackListElement> list = new ArrayList<MultipleStackListElement>();
        ArrayList validItems = new ArrayList();
        try {
            validItems.addAll(((IBackpackDefinition)BackpackManager.definitions.get(backpackID)).getValidItems(null));
        }
        catch (Exception ex) {
            NEIPlugins.logFine("Failed to retrieve valid items from backpack definition {0}", ex, backpackID);
            return false;
        }
        if (validItems.isEmpty()) {
            return false;
        }
        Collections.sort(validItems, new ItemStackComparator());
        Iterator<ItemStack> stacks = validItems.iterator();
        Dimension eSize = new Dimension(140, 16);
        while (stacks.hasNext()) {
            list.add(new MultipleStackListElement(stacks, 4, eSize));
        }
        if (list.isEmpty()) {
            return false;
        }
        Minecraft mc = NEIClientUtils.mc();
        if (!(mc.field_71462_r instanceof GuiContainer)) {
            return false;
        }
        GuiContainer prevscreen = (GuiContainer)mc.field_71462_r;
        NEIClientUtils.overlayScreen((GuiScreen)new GuiBackpackContentlist(prevscreen, ((IBackpackDefinition)BackpackManager.definitions.get(backpackID)).getName(), list));
        return true;
    }

    static class ListElement1
    extends SimpleListActiveElement {
        String key;

        ListElement1(String title, String key, boolean active) {
            super(title, active);
            this.key = key;
        }

        @Override
        public boolean click(int button) {
            return GuiBackpackContentlist.showBackpackList(this.key);
        }

        @Override
        public String getTitle() {
            return this.title;
        }
    }
}

