/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.IAEItemStack;
import appeng.api.Util;
import appeng.api.WorldCoord;
import appeng.api.events.GridStorageUpdateEvent;
import appeng.api.events.GridTileLoadEvent;
import appeng.api.events.GridTileUnloadEvent;
import appeng.api.me.tiles.ICellContainer;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.tiles.ITileCable;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import extracells.BlockEnum;
import extracells.Extracells;
import extracells.ItemEnum;
import extracells.handler.FluidBusInventoryHandler;
import extracells.tileentity.ColorableECTile;
import extracells.util.ECPrivateInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityBusFluidStorage
extends ColorableECTile
implements IGridMachine,
IDirectionalMETile,
ICellContainer,
ITileCable {
    private boolean powerStatus = true;
    private boolean networkReady = true;
    private boolean fluidHandlerCached = false;
    private boolean redStoneCached = false;
    private IGridInterface grid;
    private int priority = 1;
    private String customName = StatCollector.func_74838_a((String)"tile.block.fluid.bus.storage");
    private ECPrivateInventory inventory = new ECPrivateInventory(this.customName, 54, 1);
    private FluidStack lastFluid;
    private IFluidHandler fluidHandler = null;
    private int currentTick = 0;
    private final int tickRate = Extracells.tickRateExport;

    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K) {
            ++this.currentTick;
            if (this.currentTick == this.tickRate) {
                this.currentTick = 0;
                this.doUpdateEntity();
            }
        }
    }

    public void doUpdateEntity() {
        FluidTankInfo[] tankInfos;
        if (!this.redStoneCached || !this.fluidHandlerCached) {
            BlockEnum.FLUIDSTORAGE.getBlockInstance().func_71863_a(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 1);
            this.redStoneCached = true;
            this.fluidHandlerCached = true;
        }
        if (this.getGrid() == null || this.field_70331_k.field_72995_K) {
            return;
        }
        FluidStack tankFluid = null;
        if (this.fluidHandler != null && (tankInfos = this.fluidHandler.getTankInfo(this.getFacing().getOpposite())) != null && tankInfos.length > 0 && tankInfos[0] != null) {
            tankFluid = tankInfos[0].fluid;
        }
        if (tankFluid != null && !tankFluid.isFluidStackIdentical(this.lastFluid) || this.lastFluid != null && !this.lastFluid.isFluidStackIdentical(tankFluid)) {
            if (this.lastFluid != null) {
                IAEItemStack toRemove = Util.createItemStack((ItemStack)new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), 1, this.lastFluid.fluidID));
                toRemove.setStackSize((long)this.lastFluid.amount);
                this.getGrid().notifyExtractItems(toRemove);
            }
            if (tankFluid != null) {
                IAEItemStack toAdd = Util.createItemStack((ItemStack)new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), 1, tankFluid.fluidID));
                toAdd.setStackSize((long)tankFluid.amount);
                this.getGrid().notifyAddItems(toAdd);
                this.lastFluid = tankFluid.copy();
            } else {
                this.lastFluid = null;
            }
        }
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setFluidHandler(IFluidHandler handler) {
        this.fluidHandler = handler;
    }

    public void updateGrid() {
        if (this.getGrid() != null) {
            MinecraftForge.EVENT_BUS.post((Event)new GridStorageUpdateEvent(this.field_70331_k, this.getLocation(), this.getGrid()));
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound nbtTag = this.getColorDataForPacket();
        this.func_70310_b(nbtTag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, nbtTag);
    }

    @Override
    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        super.onDataPacket(net, packet);
        this.func_70307_a(packet.field_73331_e);
    }

    public void func_70312_q() {
        super.func_70312_q();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileLoadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public void func_70313_j() {
        super.func_70313_j();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileUnloadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public ForgeDirection getFacing() {
        return ForgeDirection.getOrientation((int)this.func_70322_n());
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74782_a("Items", (NBTBase)this.inventory.writeToNBT());
        if (this.getInventory().func_94042_c()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
        nbt.func_74768_a("Priority", this.getPriority());
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        NBTTagList nbttaglist = nbt.func_74761_m("Items");
        this.inventory.readFromNBT(nbttaglist);
        if (nbt.func_74764_b("CustomName")) {
            this.customName = nbt.func_74779_i("CustomName");
        }
        this.setPriority(nbt.func_74762_e("Priority"));
    }

    public boolean isValid() {
        return true;
    }

    public void setPowerStatus(boolean hasPower) {
        this.powerStatus = hasPower;
    }

    public boolean isPowered() {
        return this.powerStatus;
    }

    public IGridInterface getGrid() {
        return this.grid;
    }

    public void setGrid(IGridInterface gi) {
        this.grid = gi;
    }

    public World getWorld() {
        return this.field_70331_k;
    }

    public boolean canConnect(ForgeDirection dir) {
        return dir.ordinal() != this.field_70325_p;
    }

    public float getPowerDrainPerTick() {
        return 0.0f;
    }

    public WorldCoord getLocation() {
        return new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public List<IMEInventoryHandler> getCellArray() {
        ArrayList<ItemStack> filter = new ArrayList<ItemStack>();
        if (this.inventory.slots.size() > 0) {
            for (ItemStack itemStack : this.inventory.slots) {
                ItemStack fluidContainer;
                if (FluidContainerRegistry.isFilledContainer((ItemStack)itemStack)) {
                    Fluid containerFluid;
                    FluidStack containerFluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
                    if (containerFluidStack == null || (containerFluid = containerFluidStack.getFluid()) == null) continue;
                    fluidContainer = new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), 1, containerFluid.getID());
                    filter.add(fluidContainer);
                    continue;
                }
                if (itemStack == null || !(itemStack.func_77973_b() instanceof IFluidContainerItem) || ((IFluidContainerItem)itemStack.func_77973_b()).getFluid(itemStack) == null) continue;
                fluidContainer = new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), 1, ((IFluidContainerItem)itemStack.func_77973_b()).getFluid((ItemStack)itemStack).fluidID);
                filter.add(fluidContainer);
            }
        }
        ArrayList<IMEInventoryHandler> tankHandler = new ArrayList<IMEInventoryHandler>();
        if (this.fluidHandler != null) {
            tankHandler.add(new FluidBusInventoryHandler(this.fluidHandler, this.getFacing().getOpposite(), this.getPriority(), filter));
        }
        return tankHandler;
    }

    public int getPriority() {
        return this.priority;
    }

    public ECPrivateInventory getInventory() {
        return this.inventory;
    }

    public boolean coveredConnections() {
        return false;
    }

    public void setNetworkReady(boolean isReady) {
        this.networkReady = isReady;
    }

    public boolean isMachineActive() {
        return this.powerStatus && this.networkReady;
    }
}

