/*
 * Decompiled with CFR 0.152.
 */
package extracells.network.packet;

import appeng.api.config.RedstoneModeInput;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.relauncher.Side;
import extracells.network.AbstractPacket;
import extracells.tileentity.TileEntityLevelEmitterFluid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class PacketLevelEmitterFluid
extends AbstractPacket {
    World world;
    int x;
    int y;
    int z;
    long filterAmount;
    int type;

    public PacketLevelEmitterFluid(World world, int x, int y, int z, long filterAmount) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.filterAmount = filterAmount;
        this.type = 0;
    }

    public PacketLevelEmitterFluid(World world, int x, int y, int z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = 1;
    }

    public PacketLevelEmitterFluid() {
    }

    @Override
    public void write(ByteArrayDataOutput out) {
        out.writeInt(this.world.field_73011_w.field_76574_g);
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.z);
        out.writeLong(this.filterAmount);
        out.writeInt(this.type);
    }

    @Override
    public void read(ByteArrayDataInput in) throws AbstractPacket.ProtocolException {
        this.world = DimensionManager.getWorld((int)in.readInt());
        this.x = in.readInt();
        this.y = in.readInt();
        this.z = in.readInt();
        this.filterAmount = in.readLong();
        this.type = in.readInt();
    }

    @Override
    public void execute(EntityPlayer player, Side side) throws AbstractPacket.ProtocolException {
        if (side.isServer()) {
            TileEntityLevelEmitterFluid tile = (TileEntityLevelEmitterFluid)this.world.func_72796_p(this.x, this.y, this.z);
            block0 : switch (this.type) {
                case 0: {
                    tile.setAmount(this.filterAmount);
                    break;
                }
                case 1: {
                    switch (tile.getRedstoneAction()) {
                        case WhenOff: {
                            tile.setRedstoneAction(RedstoneModeInput.WhenOn);
                            break block0;
                        }
                        case WhenOn: {
                            tile.setRedstoneAction(RedstoneModeInput.WhenOff);
                            break block0;
                        }
                    }
                }
            }
        }
    }
}

