/*
 * Decompiled with CFR 0.152.
 */
package extracells.network.packet;

import appeng.api.config.RedstoneModeInput;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import extracells.gui.widget.WidgetFluidModes;
import extracells.network.AbstractPacket;
import extracells.tileentity.TileEntityBusFluidExport;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class PacketBusFluidExport
extends AbstractPacket {
    World world;
    int x;
    int y;
    int z;
    String playername;
    int action;

    public PacketBusFluidExport(World world, int x, int y, int z, int action, String playername) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.playername = playername;
        this.action = action;
    }

    public PacketBusFluidExport() {
    }

    @Override
    public void write(ByteArrayDataOutput out) {
        out.writeInt(this.world.field_73011_w.field_76574_g);
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.z);
        out.writeUTF(this.playername);
        out.writeInt(this.action);
    }

    @Override
    public void read(ByteArrayDataInput in) throws AbstractPacket.ProtocolException {
        this.world = DimensionManager.getWorld((int)in.readInt());
        this.x = in.readInt();
        this.y = in.readInt();
        this.z = in.readInt();
        this.playername = in.readUTF();
        this.action = in.readInt();
    }

    @Override
    public void execute(EntityPlayer player, Side side) throws AbstractPacket.ProtocolException {
        if (side.isServer()) {
            TileEntityBusFluidExport tile = (TileEntityBusFluidExport)this.world.func_72796_p(this.x, this.y, this.z);
            switch (this.action) {
                case 0: {
                    if (tile == null) break;
                    PacketDispatcher.sendPacketToAllPlayers((Packet)tile.func_70319_e());
                    break;
                }
                case 1: {
                    if (tile.getRedstoneMode().ordinal() >= 3) {
                        tile.setRedstoneMode(RedstoneModeInput.values()[0]);
                    } else {
                        tile.setRedstoneMode(RedstoneModeInput.values()[tile.getRedstoneMode().ordinal() + 1]);
                    }
                    if (tile == null) break;
                    PacketDispatcher.sendPacketToAllPlayers((Packet)tile.func_70319_e());
                    break;
                }
                case 2: {
                    if (tile.getFluidMode().ordinal() >= 2) {
                        tile.setFluidMode(WidgetFluidModes.FluidMode.values()[0]);
                    } else {
                        tile.setFluidMode(WidgetFluidModes.FluidMode.values()[tile.getFluidMode().ordinal() + 1]);
                    }
                    if (tile == null) break;
                    PacketDispatcher.sendPacketToAllPlayers((Packet)tile.func_70319_e());
                }
            }
        }
    }
}

