/*
 * Decompiled with CFR 0.152.
 */
package extracells.items;

import appeng.api.Util;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.Extracells;
import extracells.ItemEnum;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemStorageFluid
extends Item {
    public static final String[] suffixes = new String[]{"1k", "4k", "16k", "64k", "256k", "1m", "4m", "16m"};
    public static final int[] spaces = new int[]{1024, 4096, 16348, 65536, 262144, 0x100000, 0x400000, 0xFF7000};
    @SideOnly(value=Side.CLIENT)
    private Icon[] icons;

    public ItemStorageFluid(int id) {
        super(id);
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(Extracells.ModTab);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77617_a(int par1) {
        int j = MathHelper.func_76125_a((int)par1, (int)0, (int)7);
        return this.icons[j];
    }

    public void func_94581_a(IconRegister iconRegister) {
        this.icons = new Icon[suffixes.length];
        for (int i = 0; i < suffixes.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("extracells:storage.fluid." + suffixes[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int i, CreativeTabs creativeTab, List listSubItems) {
        for (int j = 0; j < 4; ++j) {
            listSubItems.add(new ItemStack(i, 1, j));
        }
    }

    public String func_77667_c(ItemStack itemstack) {
        int i = itemstack.func_77960_j();
        return "item.storage.fluid." + suffixes[i];
    }

    public String func_77628_j(ItemStack itemstack) {
        Boolean hasName = !Util.getCellRegistry().getHandlerForCell(itemstack).getName().isEmpty();
        String partitionName = Util.getCellRegistry().getHandlerForCell(itemstack).getName();
        long used_bytes = Util.getCellRegistry().getHandlerForCell(itemstack).usedBytes();
        if (itemstack.func_77960_j() == 4) {
            if (used_bytes != 0L && !Util.getCellRegistry().getHandlerForCell(itemstack).getAvailableItems().getItems().isEmpty()) {
                return StatCollector.func_74838_a((String)this.func_77667_c(itemstack)) + " - " + ((ItemStack)Util.getCellRegistry().getHandlerForCell(itemstack).getAvailableItems().getItems().get(0)).func_82833_r();
            }
            return StatCollector.func_74838_a((String)"tooltip.empty2") + " " + StatCollector.func_74838_a((String)this.func_77667_c(itemstack));
        }
        if (hasName.booleanValue()) {
            return StatCollector.func_74838_a((String)this.func_77667_c(itemstack)) + " - " + partitionName;
        }
        return StatCollector.func_74838_a((String)this.func_77667_c(itemstack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        Boolean partitioned = Util.getCellRegistry().getHandlerForCell(stack).isPreformatted();
        long used_bytes = Util.getCellRegistry().getHandlerForCell(stack).usedBytes();
        long total_bytes = Util.getCellRegistry().getHandlerForCell(stack).totalBytes();
        long used_types = Util.getCellRegistry().getHandlerForCell(stack).storedItemTypes();
        long total_types = Util.getCellRegistry().getHandlerForCell(stack).getTotalItemTypes();
        Util.getCellRegistry().getHandlerForCell(stack).getPreformattedItems();
        list.add(used_bytes / 250L + " of " + total_bytes / 250L + " bytes used");
        list.add(used_types + " of " + total_types + " fluid types used");
        if (used_bytes != 0L) {
            list.add("contains " + used_bytes + "mB of fluid");
        }
        if (partitioned.booleanValue()) {
            list.add(StatCollector.func_74838_a((String)"Appeng.GuiITooltip.Partitioned") + " - " + StatCollector.func_74838_a((String)"Appeng.GuiITooltip.Precise"));
        }
    }

    public ItemStack func_77659_a(ItemStack i, World w, EntityPlayer p) {
        if (p.func_70093_af() && Util.getCellRegistry().getHandlerForCell(i).storedItemCount() == 0L && p.field_71071_by.func_70441_a(new ItemStack(ItemEnum.STORAGECASING.getItemInstance(), 1, 1))) {
            return new ItemStack(ItemEnum.STORAGECOMPONENT.getItemInstance(), 1, i.func_77960_j() + 4);
        }
        return i;
    }

    public int getBytes(ItemStack itemstack) {
        return spaces[itemstack.func_77960_j()] * 250;
    }

    public int getTotalTypes(ItemStack i) {
        return 5;
    }

    public EnumRarity func_77613_e(ItemStack par1) {
        return EnumRarity.epic;
    }
}

