/*
 * Decompiled with CFR 0.152.
 */
package mariculture.world.decorate;

import java.util.Random;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.lib.WorldGeneration;
import mariculture.world.WorldPlus;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ChestGenHooks;

public class WorldGenKelp
extends WorldGenerator {
    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        return this.generate(world, random, x, z, false, 3, WorldGeneration.KELP_PATCH_DENSITY);
    }

    public boolean generate(World world, Random random, int x, int z, boolean chests, int max, int times) {
        for (int l = 0; l < times; ++l) {
            int x2 = x + random.nextInt(8) - random.nextInt(8);
            int z2 = z + random.nextInt(8) - random.nextInt(8);
            if (!world.func_72863_F().func_73149_a(x2 >> 4, z2 >> 4)) continue;
            try {
                this.generateKelp(world, random, x, z, chests, max);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return true;
    }

    public boolean generateKelp(World world, Random rand, int xCoord, int zCoord, boolean chests, int maxHeight) {
        int yCoord = world.func_72825_h(xCoord, zCoord);
        if (world.func_72799_c(xCoord, yCoord + WorldGeneration.KELP_DEPTH, zCoord) && this.canBlockStay(world, xCoord, yCoord, zCoord)) {
            if (chests && rand.nextInt(WorldGeneration.KELP_CHEST_CHANCE) == 0) {
                return this.generateChest(world, rand, xCoord, zCoord);
            }
            int max = this.getMaxHeight(world, xCoord, zCoord, maxHeight);
            int theHeight = rand.nextInt(max) + 1;
            int theY = 0;
            for (int y = 0; y < theHeight; ++y) {
                if (!BlockHelper.isWater(world, xCoord, yCoord + y + 2, zCoord)) continue;
                ++theY;
                world.func_72832_d(xCoord, yCoord + y, zCoord, WorldPlus.coral.field_71990_ca, 1, 2);
            }
            WorldPlus.coral.func_85105_g(world, xCoord, yCoord + (theY - 1), zCoord, 0);
            return true;
        }
        return false;
    }

    private int getMaxHeight(World world, int xCoord, int zCoord, int maxHeight) {
        int yCoord = world.func_72825_h(xCoord, zCoord);
        for (int height = 1; height <= maxHeight; ++height) {
            if (BlockHelper.isWater(world, xCoord, yCoord + (height - 1), zCoord)) continue;
            return height;
        }
        return maxHeight;
    }

    private boolean generateChest(World world, Random random, int x, int z) {
        int facing = random.nextInt(4);
        int y = world.func_72825_h(x, z);
        if (BlockHelper.isWater(world, x, y + 10, z) && BlockHelper.isWater(world, x, y, z) && world.func_72798_a(x + 1, y, z) != Block.field_72077_au.field_71990_ca && world.func_72798_a(x - 1, y, z) != Block.field_72077_au.field_71990_ca && world.func_72798_a(x, y, z + 1) != Block.field_72077_au.field_71990_ca && world.func_72798_a(x, y, z - 1) != Block.field_72077_au.field_71990_ca) {
            world.func_72832_d(x, y, z, Block.field_72077_au.field_71990_ca, 1, facing);
            TileEntityChest chest = (TileEntityChest)world.func_72796_p(x, y, z);
            if (chest != null) {
                WeightedRandomChestContent.func_76293_a((Random)random, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"oceanFloorChest", (Random)random), (IInventory)chest, (int)(random.nextInt(5) + random.nextInt(5) + 2));
                return true;
            }
        }
        return false;
    }

    private boolean canBlockStay(World world, int x, int y, int z) {
        if (!BlockHelper.isWater(world, x, y + 2, z)) {
            return false;
        }
        if (world.func_72798_a(x, y - 1, z) == WorldPlus.coral.field_71990_ca && world.func_72805_g(x, y - 1, z) <= 1) {
            return true;
        }
        if (world.func_72798_a(x, y - 1, z) == Block.field_71940_F.field_71990_ca) {
            return true;
        }
        if (world.func_72798_a(x, y - 1, z) == Block.field_71978_w.field_71990_ca) {
            return true;
        }
        if (world.func_72798_a(x, y - 1, z) == Block.field_72087_ao.field_71990_ca) {
            return true;
        }
        return world.func_72798_a(x, y - 1, z) == Block.field_71939_E.field_71990_ca;
    }
}

