/*
 * Decompiled with CFR 0.152.
 */
package mariculture.world;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.logging.Level;
import mariculture.core.Core;
import mariculture.core.handlers.LogHandler;
import mariculture.core.helpers.RecipeHelper;
import mariculture.core.helpers.RegistryHelper;
import mariculture.core.lib.BlockIds;
import mariculture.core.lib.Modules;
import mariculture.core.lib.WorldGeneration;
import mariculture.factory.Factory;
import mariculture.fishery.Fishery;
import mariculture.world.BlockCoral;
import mariculture.world.ItemCoral;
import mariculture.world.WorldEvents;
import mariculture.world.WorldGen;
import mariculture.world.terrain.BiomeGenSandyOcean;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

public class WorldPlus
extends Modules.RegistrationModule {
    public static final String OCEAN_CHEST = "oceanFloorChest";
    public static Block coral;
    @Deprecated
    public static boolean isActive;

    @Override
    public void registerHandlers() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGen());
        if (!Loader.isModLoaded((String)"ATG")) {
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)new WorldEvents());
        }
    }

    @Override
    public void registerBlocks() {
        coral = new BlockCoral(BlockIds.coral).func_71884_a(Block.field_71965_g).func_71894_b(0.1f).func_71864_b("coral");
        Item.field_77698_e[BlockIds.coral] = new ItemCoral(BlockIds.coral - 256, coral).func_77655_b("coral");
        OreDictionary.registerOre((String)"plantKelp", (ItemStack)new ItemStack(coral, 1, 0));
        RegistryHelper.register(new Object[]{coral});
    }

    @Override
    public void registerItems() {
    }

    @Override
    public void registerOther() {
        RegistryHelper.registerCoral(new ItemStack(coral, 1, 4), "LightBlue");
        RegistryHelper.registerCoral(new ItemStack(coral, 1, 7), "Yellow");
        RegistryHelper.registerCoral(new ItemStack(coral, 1, 5), "Magenta");
        RegistryHelper.registerCoral(new ItemStack(coral, 1, 6), "Brown");
        RegistryHelper.registerCoral(new ItemStack(coral, 1, 8), "Orange");
        RegistryHelper.registerCoral(new ItemStack(coral, 1, 2), "Pink");
        RegistryHelper.registerCoral(new ItemStack(coral, 1, 9), "Purple");
        RegistryHelper.registerCoral(new ItemStack(coral, 1, 3), "Red");
        OreDictionary.registerOre((String)"coralWhite", (ItemStack)new ItemStack(coral, 1, 12));
        OreDictionary.registerOre((String)"coralGray", (ItemStack)new ItemStack(coral, 1, 10));
        OreDictionary.registerOre((String)"coralLightGray", (ItemStack)new ItemStack(coral, 1, 11));
        if (WorldGeneration.DEEP_OCEAN) {
            this.addDeepOcean();
        }
    }

    private void addDeepOcean() {
        try {
            Field field = BiomeGenBase.class.getField("ocean");
            if (field == null) {
                field = BiomeGenBase.class.getField("field_76771_b");
            }
            BiomeGenBase newValue = new BiomeGenSandyOcean(0).func_76739_b(112).func_76735_a("Ocean").func_76725_b(-1.85f, 0.4f);
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(null, newValue);
        }
        catch (Exception e) {
            LogHandler.log(Level.INFO, "Mariculture failed to adjust the ocean depth");
        }
    }

    @Override
    public void registerRecipes() {
        RecipeHelper.addCrushRecipe(new ItemStack(Core.materials, 1, 32), "coralBrown", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Core.materials, 1, 31), "coralRed", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Core.materials, 1, 30), "coralYellow", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Item.field_77756_aW, 1, 12), "coralLightBlue", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Item.field_77756_aW, 1, 13), "coralMagenta", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Item.field_77756_aW, 1, 14), "coralOrange", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Item.field_77756_aW, 1, 9), "coralPink", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Item.field_77756_aW, 1, 5), "coralPurple", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Item.field_77756_aW, 1, 8), "coralGray", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Item.field_77756_aW, 1, 7), "coralLightGray", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Core.materials, 1, 27), "coralWhite", false);
        RecipeHelper.addCrushRecipe(new ItemStack(Core.materials, 1, 29), "plantKelp", true);
        RecipeHelper.addBleachRecipe(new ItemStack(coral, 1, 4), new ItemStack(coral, 1, 10), 5);
        RecipeHelper.addBleachRecipe(new ItemStack(coral, 1, 7), new ItemStack(coral, 1, 10), 5);
        RecipeHelper.addBleachRecipe(new ItemStack(coral, 1, 5), new ItemStack(coral, 1, 10), 5);
        RecipeHelper.addBleachRecipe(new ItemStack(coral, 1, 6), new ItemStack(coral, 1, 10), 5);
        RecipeHelper.addBleachRecipe(new ItemStack(coral, 1, 8), new ItemStack(coral, 1, 10), 5);
        RecipeHelper.addBleachRecipe(new ItemStack(coral, 1, 2), new ItemStack(coral, 1, 10), 5);
        RecipeHelper.addBleachRecipe(new ItemStack(coral, 1, 9), new ItemStack(coral, 1, 10), 5);
        RecipeHelper.addBleachRecipe(new ItemStack(coral, 1, 3), new ItemStack(coral, 1, 10), 5);
        RecipeHelper.addBleachRecipe(new ItemStack(coral, 1, 10), new ItemStack(coral, 1, 11), 5);
        RecipeHelper.addBleachRecipe(new ItemStack(coral, 1, 11), new ItemStack(coral, 1, 12), 5);
        RecipeHelper.add3x3Recipe(new ItemStack(Core.food, 1, 8), "plantKelp");
        this.addOceanChestLoot();
    }

    private void addOceanChestLoot() {
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Item.field_77755_aX, 7, 0), 5, 10, 25));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Item.field_82799_bQ, 1, 0), 5, 5, 5));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Item.field_82799_bQ, 1, 1), 2, 3, 3));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Block.field_72091_am), 2, 4, 4));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Item.field_77759_aK, 3, 0), 2, 3, 20));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Item.field_77760_aL, 1, 0), 2, 3, 15));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Item.field_77809_bD, 1, 0), 5, 10, 20));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Item.field_77821_bF, 1, 0), 1, 4, 4));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack((Item)Item.field_77744_bd, 1, 0), 1, 1, 5));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Item.field_77717_p, 1, 0), 10, 20, 10));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Item.field_77702_n, 1, 0), 1, 2, 3));
        ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Core.materials, 1, 2), 1, 3, 4));
        if (Modules.isActive(Modules.factory)) {
            ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Factory.fludd), 1, 2, 1));
        }
        if (Modules.isActive(Modules.fishery)) {
            ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Fishery.rodReed), 1, 2, 6));
            ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Fishery.rodWood), 1, 2, 4));
            ChestGenHooks.addItem((String)OCEAN_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Fishery.rodTitanium), 1, 1, 2));
        }
    }

    static {
        isActive = Modules.isActive(Modules.worldplus);
    }
}

