/*
 * Decompiled with CFR 0.152.
 */
package mariculture.world;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import mariculture.core.handlers.WorldGenHandler;
import mariculture.core.lib.Extra;
import mariculture.core.lib.WorldGeneration;
import mariculture.plugins.PluginBiomesOPlenty;
import mariculture.world.decorate.WorldGenKelp;
import mariculture.world.decorate.WorldGenKelpForest;
import mariculture.world.decorate.WorldGenReef;
import mariculture.world.decorate.WorldGenReef172;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                break;
            }
            case 0: {
                this.generateOverworld(world, random, chunkX * 16, chunkZ * 16);
            }
            case 1: {
                break;
            }
            default: {
                this.generateOverworld(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateOverworld(World world, Random random, int x, int z) {
        if (WorldGenHandler.isOceanBiome(world, x, z)) {
            this.generateOceanFeatures(world, random, x, z);
        }
    }

    private void generateOceanFeatures(World world, Random random, int x, int z) {
        try {
            if (WorldGeneration.CORAL_ENABLED) {
                WorldGen.generateCoral(world, random, x, z);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (WorldGeneration.KELP_PATCH_ENABLED) {
                WorldGen.generateKelp(world, random, x, z);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (WorldGeneration.KELP_FOREST_ENABLED) {
                WorldGen.generateKelpForest(world, random, x, z);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generateCoral(World world, Random random, int x, int z) {
        boolean isCoralReef = PluginBiomesOPlenty.isBiome(world, x, z, PluginBiomesOPlenty.Biome.CORAL);
        int chance = Extra.HAS_BOP ? WorldGeneration.CORAL_CHANCE : WorldGeneration.CORAL_CHANCE * 10;
        int n = chance = chance <= 1 ? 1 : chance;
        if (isCoralReef && random.nextInt(chance) == 0) {
            int x2 = x + random.nextInt(16) + 8;
            int z2 = z + random.nextInt(16) + 8;
            if (WorldGeneration.CORAL_EXPERIMENTAL) {
                new WorldGenReef172().func_76484_a(world, random, x, 0, z2);
            } else {
                new WorldGenReef(128).generate(world, random, x2, z2);
            }
        }
    }

    public static void generateKelp(World world, Random random, int x, int z) {
        int chance = WorldGeneration.KELP_CHANCE / 128;
        int n = chance = chance <= 1 ? 1 : chance;
        if (random.nextInt(chance) == 0) {
            for (int j = 0; j < 5; ++j) {
                int x2 = x + random.nextInt(16) + 8;
                int z2 = z + random.nextInt(16) + 8;
                new WorldGenKelp().func_76484_a(world, random, x2, 0, z2);
            }
        }
    }

    public static void generateKelpForest(World world, Random random, int x, int z) {
        boolean isKelpForest = PluginBiomesOPlenty.isBiome(world, x, z, PluginBiomesOPlenty.Biome.KELP);
        int maxHeight = WorldGeneration.KELP_HEIGHT;
        int chance = Extra.HAS_BOP ? WorldGeneration.KELP_CHANCE : WorldGeneration.KELP_CHANCE * 3;
        chance = chance <= 1 ? 1 : chance;
        int n = maxHeight = maxHeight <= 1 ? 1 : maxHeight;
        if (isKelpForest && random.nextInt(chance) + 1 == 1) {
            int x2 = x + random.nextInt(16) + 8;
            int z2 = z + random.nextInt(16) + 8;
            new WorldGenKelpForest().generate(world, random, x2, 0, z2, maxHeight);
        }
    }
}

