/*
 * Decompiled with CFR 0.152.
 */
package mariculture.world;

import java.util.logging.Level;
import mariculture.core.handlers.LogHandler;
import mariculture.core.lib.Extra;
import mariculture.core.lib.WorldGeneration;
import mariculture.world.terrain.MapGenCavesWater;
import mariculture.world.terrain.MapGenMineshaftsDisabled;
import mariculture.world.terrain.MapGenRavineWater;
import mariculture.world.terrain.MapGenRavineWaterBOP;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;

public class WorldEvents {
    @ForgeSubscribe
    public void onWorldGen(InitMapGenEvent event) {
        if (WorldGeneration.NO_MINESHAFTS && event.type == InitMapGenEvent.EventType.MINESHAFT) {
            try {
                event.newGen = new MapGenMineshaftsDisabled();
            }
            catch (Exception e) {
                LogHandler.log(Level.INFO, "Mariculture couldn't remove mineshafts from oceans");
            }
        }
        if (WorldGeneration.WATER_CAVES && event.type == InitMapGenEvent.EventType.CAVE) {
            try {
                event.newGen = new MapGenCavesWater();
            }
            catch (Exception e) {
                LogHandler.log(Level.INFO, "Mariculture couldn't add water filled caves");
            }
        }
        if (WorldGeneration.WATER_RAVINES && event.type == InitMapGenEvent.EventType.RAVINE) {
            try {
                event.newGen = Extra.HAS_BOP ? new MapGenRavineWaterBOP() : new MapGenRavineWater();
            }
            catch (Exception e) {
                LogHandler.log(Level.INFO, "Mariculture couldn't add water filled ravines");
            }
        }
    }

    @ForgeSubscribe
    public void onWorldDecorate(DecorateBiomeEvent.Decorate event) {
    }
}

