/*
 * Decompiled with CFR 0.152.
 */
package mariculture.world;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mariculture.api.core.CoralRegistry;
import mariculture.api.core.MaricultureRegistry;
import mariculture.api.core.MaricultureTab;
import mariculture.core.Core;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.helpers.RegistryHelper;
import mariculture.core.lib.Extra;
import mariculture.core.util.IItemRegistry;
import mariculture.world.WorldPlus;
import mariculture.world.decorate.WorldGenReef172;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class BlockCoral
extends Block
implements IPlantable,
IItemRegistry {
    private Icon[] icons;

    protected BlockCoral(int i) {
        super(i, Material.field_76244_g);
        float f = 0.375f;
        this.func_71905_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 1.0f, 0.5f + f);
        this.func_71907_b(true);
        this.func_71849_a(MaricultureTab.tabMariculture);
    }

    public float func_71934_m(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) <= 1) {
            return 0.05f;
        }
        return 1.0f;
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        if (world.func_72805_g(x, y, z) == 0) {
            this.updateKelp(world, x, y, z, rand);
        } else if (world.func_72798_a(x, y - 1, z) != this.field_71990_ca) {
            if (world.func_72805_g(x, y, z) == 1) {
                this.updateMoss(world, x, y, z, rand);
            } else {
                this.updateCoral(world, x, y, z, rand);
            }
        }
    }

    private void updateCoral(World world, int x, int y, int z, Random rand) {
        if (rand.nextInt(Extra.CORAL_SPREAD_CHANCE) == 0) {
            int xBonus = rand.nextInt(3) - 1;
            int zBonus = rand.nextInt(3) - 1;
            BlockCoral.spread(world, x + xBonus, y, z + zBonus, rand);
        }
    }

    private void updateKelp(World world, int x, int y, int z, Random rand) {
        if (rand.nextInt(Extra.KELP_GROWTH_CHANCE) == 0 && BlockHelper.isWater(world, x, y + 1, z) && BlockHelper.isWater(world, x, y + 2, z)) {
            world.func_72832_d(x, y + 1, z, this.field_71990_ca, 0, 2);
            this.func_85105_g(world, x, y + 1, z, 0);
        }
    }

    private void updateMoss(World world, int x, int y, int z, Random rand) {
        int z2;
        int x2;
        if ((world.func_72798_a(x, y - 1, z) == Block.field_72087_ao.field_71990_ca || world.func_72798_a(x, y - 1, z) == Block.field_72007_bm.field_71990_ca && world.func_72805_g(x, y - 1, z) == 1) && rand.nextInt(Extra.KELP_SPREAD_CHANCE) == 0 && BlockHelper.isWater(world, x2 = x + rand.nextInt(4) - 2, y, z2 = z + rand.nextInt(4) - 2)) {
            if (world.func_72798_a(x2, y - 1, z2) == Block.field_71978_w.field_71990_ca) {
                world.func_94575_c(x2, y - 1, z2, Block.field_72087_ao.field_71990_ca);
            }
            if (world.func_72798_a(x2, y - 1, z2) == Block.field_72007_bm.field_71990_ca && world.func_72805_g(x2, y - 1, z2) == 0) {
                world.func_72921_c(x2, y - 1, z2, 1, 2);
            }
        }
    }

    public boolean isBlockReplaceable(World world, int x, int y, int z) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71920_b(IBlockAccess block, int x, int y, int z) {
        if (block.func_72805_g(x, y, z) <= 1) {
            int id4;
            int id3;
            int id2;
            int id1 = block.func_72798_a(x + 1, 16, z);
            int number = id1 * (id2 = block.func_72798_a(x, y, z + 8)) * (id3 = block.func_72805_g(x - 6, 25, z)) * (id4 = block.func_72798_a(x, 5, z)) + z + x;
            int n = number = number <= 0 ? -number : number;
            if (number % 13 == 0) {
                return 1900371;
            }
            if (number % 12 == 0) {
                return 1887059;
            }
            if (number % 11 == 0) {
                return 1860179;
            }
            if (number % 10 == 0) {
                return 2970947;
            }
            if (number % 9 == 0) {
                return 2986563;
            }
            if (number % 8 == 0) {
                return 2986594;
            }
            if (number % 7 == 0) {
                return 0xFFFFFF;
            }
            if (number % 6 == 0) {
                return 0x619961;
            }
            if (number % 5 == 0) {
                return 8431445;
            }
            if (number % 4 == 0) {
                return 4764952;
            }
            if (number % 3 == 0) {
                return 0xFFFFFF;
            }
            if (number % 2 == 0) {
                return 7719028;
            }
            return 5411426;
        }
        return 0xFFFFFF;
    }

    public static void fullSpread(World world, int x, int y, int z, Random random) {
        for (int x2 = -3; x2 < 5; ++x2) {
            for (int z2 = -3; z2 < 5; ++z2) {
                BlockCoral.spread(world, x + x2, y - 1, z + z2, random);
                BlockCoral.spread(world, x + x2 + 1, y - 1, z + z2, random);
                BlockCoral.spread(world, x + x2 - 1, y - 1, z + z2, random);
                BlockCoral.spread(world, x + x2, y - 1, z + 1 + z2, random);
                BlockCoral.spread(world, x + x2, y - 1, z - 1 + z2, random);
            }
        }
    }

    private static void spread(World world, int x, int y, int z, Random random) {
        for (int y2 = -2; y2 < 3; ++y2) {
            if (!BlockCoral.isValidFloor(world, x, y + y2, z) || !BlockHelper.isWater(world, x, y + y2 + 1, z)) continue;
            if (random.nextInt(5096) == 1) {
                world.func_94575_c(x, y + y2 + 1, z, Block.field_71945_L.field_71990_ca);
                continue;
            }
            ItemStack coral = CoralRegistry.corals.get(random.nextInt(CoralRegistry.corals.size()));
            world.func_72832_d(x, y + y2 + 1, z, coral.field_77993_c, coral.func_77960_j(), 2);
        }
    }

    private static boolean isValidFloor(World world, int x, int y, int z) {
        if (!BlockHelper.chunkExists(world, x, z)) {
            return false;
        }
        return world.func_72798_a(x, y, z) == Core.ores.field_71990_ca && world.func_72805_g(x, y, z) == 7;
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        if (world.func_72798_a(x, y - 1, z) == WorldPlus.coral.field_71990_ca && world.func_72805_g(x, y - 1, z) == 1) {
            world.func_72921_c(x, y - 1, z, 0, 2);
        }
    }

    public boolean canSustainPlant(World world, int x, int y, int z, ForgeDirection direction, IPlantable plant) {
        if (world.func_72803_f(x, y, z) != Material.field_76244_g) {
            return false;
        }
        int blockID = world.func_72798_a(x, y - 1, z);
        int meta = world.func_72805_g(x, y - 1, z);
        if (world.func_72798_a(x, y, z) == WorldPlus.coral.field_71990_ca) {
            if (world.func_72805_g(x, y, z) <= 1) {
                if (blockID == WorldPlus.coral.field_71990_ca && meta <= 1) {
                    return true;
                }
                if (blockID == Block.field_71940_F.field_71990_ca) {
                    return true;
                }
                if (blockID == Block.field_71978_w.field_71990_ca) {
                    return true;
                }
                if (blockID == Block.field_72087_ao.field_71990_ca) {
                    return true;
                }
                if (blockID == Core.ores.field_71990_ca && meta == 7) {
                    return true;
                }
                if (blockID == Block.field_71939_E.field_71990_ca) {
                    return true;
                }
            } else if (world.func_72805_g(x, y, z) > 1) {
                if (blockID == Block.field_71978_w.field_71990_ca) {
                    return true;
                }
                if (blockID == Block.field_72087_ao.field_71990_ca) {
                    return true;
                }
                if (blockID == Core.ores.field_71990_ca && meta == 7) {
                    return true;
                }
                return WorldGenReef172.coralCanReplace(world, x, y - 1, z);
            }
        }
        return false;
    }

    public void func_71863_a(World par1World, int par2, int par3, int par4, int par5) {
        if (!this.func_71854_d(par1World, par2, par3, par4)) {
            this.func_71897_c(par1World, par2, par3, par4, par1World.func_72805_g(par2, par3, par4), 0);
            par1World.func_94575_c(par2, par3, par4, Block.field_71943_B.field_71990_ca);
        }
    }

    public boolean func_71854_d(World world, int x, int y, int z) {
        return this.canSustainPlant(world, x, y, z, ForgeDirection.UNKNOWN, this);
    }

    public void func_85105_g(World world, int x, int y, int z, int meta) {
        world.func_72898_h(x, y, z, meta);
        if (BlockHelper.isWater(world, x, y - 1, z) && !world.func_72799_c(x, y + 1, z)) {
            world.func_94575_c(x, y, z, Block.field_71943_B.field_71990_ca);
        }
        if (world.func_72805_g(x, y, z) <= 1) {
            if (world.func_72798_a(x, y - 1, z) == this.field_71990_ca) {
                world.func_72921_c(x, y - 1, z, 1, 2);
            }
            if (world.func_72798_a(x, y + 1, z) == this.field_71990_ca) {
                world.func_72921_c(x, y, z, 1, 2);
            }
            if (world.func_72798_a(x, y + 1, z) != this.field_71990_ca) {
                world.func_72921_c(x, y, z, 0, 2);
            }
        }
        world.func_72898_h(x, y, z, meta);
    }

    public AxisAlignedBB func_71872_e(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public int func_71885_a(int i, Random random, int j) {
        return this.field_71990_ca;
    }

    public int func_71899_b(int i) {
        if (i == 1) {
            return 0;
        }
        return i;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return 1;
    }

    public EnumPlantType getPlantType(World world, int x, int y, int z) {
        return EnumPlantType.Water;
    }

    public int getPlantID(World world, int x, int y, int z) {
        return this.field_71990_ca;
    }

    public int getPlantMetadata(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public Icon func_71858_a(int side, int meta) {
        return this.icons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.icons = new Icon[this.getMetaCount()];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("mariculture:coral_" + this.getName(new ItemStack(this.field_71990_ca, 1, i)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int id, CreativeTabs creativeTabs, List list) {
        for (int meta = 0; meta < 13; ++meta) {
            if (meta == 1) continue;
            list.add(new ItemStack(id, 1, meta));
        }
    }

    @Override
    public void register() {
        for (int j = 0; j < this.getMetaCount(); ++j) {
            if (j == 1) {
                ++j;
            }
            MaricultureRegistry.register("coral." + this.getName(new ItemStack(this.field_71990_ca, 1, j)), new ItemStack(this.field_71990_ca, 1, j));
        }
    }

    @Override
    public int getMetaCount() {
        return 13;
    }

    @Override
    public String getName(ItemStack stack) {
        return RegistryHelper.getName(stack);
    }
}

