/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins.nei;

import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.ArrayList;
import java.util.HashMap;
import mariculture.api.core.MaricultureHandlers;
import mariculture.core.lib.Extra;
import mariculture.core.lib.Modules;
import mariculture.fishery.Fishery;
import mariculture.magic.JewelryHandler;
import mariculture.magic.Magic;
import mariculture.magic.jewelry.ItemJewelry;
import mariculture.magic.jewelry.parts.JewelryPart;
import mariculture.plugins.nei.NEIAnvilRecipeHandler;
import mariculture.plugins.nei.NEIBlockCasterRecipeHandler;
import mariculture.plugins.nei.NEIFishBreedingMutationHandler;
import mariculture.plugins.nei.NEIFishProductHandler;
import mariculture.plugins.nei.NEIIngotCasterRecipeHandler;
import mariculture.plugins.nei.NEILiquifierRecipeHandler;
import mariculture.plugins.nei.NEISifterRecipeHandler;
import mariculture.plugins.nei.NEIVatRecipeHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class NEIConfig
implements IConfigureNEI {
    public static final HashMap<String, ArrayList<ItemStack>> containers = new HashMap();

    public void loadConfig() {
        FluidContainerRegistry.FluidContainerData[] data;
        API.registerRecipeHandler((ICraftingHandler)new NEILiquifierRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new NEILiquifierRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new NEIVatRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new NEIVatRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new NEIIngotCasterRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new NEIIngotCasterRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new NEIBlockCasterRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new NEIBlockCasterRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new NEIAnvilRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new NEIAnvilRecipeHandler());
        if (Modules.isActive(Modules.fishery)) {
            API.registerRecipeHandler((ICraftingHandler)new NEISifterRecipeHandler());
            API.registerUsageHandler((IUsageHandler)new NEISifterRecipeHandler());
            API.registerRecipeHandler((ICraftingHandler)new NEIFishBreedingMutationHandler());
            API.registerUsageHandler((IUsageHandler)new NEIFishBreedingMutationHandler());
            API.registerRecipeHandler((ICraftingHandler)new NEIFishProductHandler());
            API.registerUsageHandler((IUsageHandler)new NEIFishProductHandler());
            if (Extra.DISABLE_FISH) {
                API.hideItem((int)Fishery.fishy.field_77779_bT);
            }
        }
        for (FluidContainerRegistry.FluidContainerData container : data = (FluidContainerRegistry.FluidContainerData[])FluidContainerRegistry.getRegisteredFluidContainerData().clone()) {
            ArrayList<Object> list;
            String fluid = container.fluid.getFluid().getName();
            if (containers.containsKey("fluid")) {
                list = containers.get(fluid);
                list.add(container.filledContainer);
                continue;
            }
            list = new ArrayList();
            list.add(container.filledContainer);
            containers.put(fluid, list);
        }
        if (Modules.isActive(Modules.magic)) {
            this.addJewelry(Magic.ring.field_77779_bT, 0, "jewel", "material");
            this.addJewelry(Magic.bracelet.field_77779_bT, 1, "material", "string");
            this.addJewelry(Magic.necklace.field_77779_bT, 2, "material", "string");
        }
    }

    private void addJewelry(int id, int type, String partOne, String partTwo) {
        for (int i = 0; i < JewelryPart.materialList.size(); ++i) {
            for (int j = 0; j < JewelryPart.materialList.size(); ++j) {
                int Multiply1;
                if (!JewelryPart.materialList.get(i).isValid(type) || !JewelryPart.materialList.get(j).isValid(type) || !JewelryPart.materialList.get(i).getPartType(type).equals(partOne) || !JewelryPart.materialList.get(j).getPartType(type).equals(partTwo)) continue;
                ItemStack output = ItemJewelry.buildJewelry(id, i, j);
                output = JewelryPart.materialList.get(i).addEnchantments(output);
                if (i != j) {
                    output = JewelryPart.materialList.get(j).addEnchantments(output);
                }
                ItemStack input1 = JewelryPart.materialList.get(i).getItemStack();
                ItemStack input2 = JewelryPart.materialList.get(j).getItemStack();
                int n = type == 0 ? 1 : (Multiply1 = type == 1 ? 3 : 7);
                int Multiply2 = type == 0 ? 7 : (type == 1 ? 2 : 1);
                int frame = JewelryPart.materialList.get(i).getHits(type) * Multiply1;
                int other = JewelryPart.materialList.get(j).getHits(type) * Multiply2;
                int hits = frame + other;
                if (input1 == null || input2 == null || output == null) continue;
                String damage = "" + JewelryHandler.getUIdentifier(output, input1, input2);
                ItemStack piece = MaricultureHandlers.anvil.createWorkedItem(output, hits);
                piece.func_77964_b(Integer.parseInt(damage));
                NEIAnvilRecipeHandler.jewelry.put(output, new NEIAnvilRecipeHandler.RecipeJewelry(piece, hits));
            }
        }
    }

    public String getName() {
        return "Mariculture NEI";
    }

    public String getVersion() {
        return "1.0";
    }
}

