/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins.nei;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mariculture.api.core.RecipeCasting;
import mariculture.core.gui.feature.FeatureTank;
import mariculture.core.helpers.OreDicHelper;
import mariculture.core.helpers.cofh.StringHelper;
import mariculture.plugins.nei.NEIBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public abstract class NEICastingRecipeHandler
extends NEIBase {
    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier()) && ((Object)((Object)this)).getClass() == this.thisClass()) {
            HashMap<String, RecipeCasting> recipes = this.getRecipes();
            for (Map.Entry<String, RecipeCasting> recipe : recipes.entrySet()) {
                this.arecipes.add(new CachedCasterRecipe(recipe.getValue().fluid, recipe.getValue().output));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        boolean isSecondSearch = this.isSecondSearch(inputId, ingredients);
        if ((inputId.equals(this.getOverlayIdentifier()) || isSecondSearch) && ((Object)((Object)this)).getClass() == this.thisClass()) {
            HashMap<String, RecipeCasting> recipes = this.getRecipes();
            for (Map.Entry<String, RecipeCasting> recipe : recipes.entrySet()) {
                if (isSecondSearch && (!isSecondSearch || !recipe.getValue().fluid.getFluid().getName().equals(ingredients[1]))) continue;
                this.arecipes.add(new CachedCasterRecipe(recipe.getValue().fluid, recipe.getValue().output));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        HashMap<String, RecipeCasting> recipes = this.getRecipes();
        for (Map.Entry<String, RecipeCasting> recipe : recipes.entrySet()) {
            if (!OreDicHelper.convert(result).equals(OreDicHelper.convert(recipe.getValue().output))) continue;
            this.arecipes.add(new CachedCasterRecipe(recipe.getValue().fluid, recipe.getValue().output));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        HashMap<String, RecipeCasting> recipes = this.getRecipes();
        for (Map.Entry<String, RecipeCasting> recipe : recipes.entrySet()) {
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)ingredient);
            if (fluid == null || !fluid.getFluid().getName().equals(recipe.getValue().fluid)) continue;
            this.arecipes.add(new CachedCasterRecipe(recipe.getValue().fluid, recipe.getValue().output));
        }
    }

    public void drawExtras(int id) {
        CachedCasterRecipe cache = (CachedCasterRecipe)((Object)this.arecipes.get(id));
        this.drawFluidRect(22, 15, cache.fluid, this.getTankType());
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int id) {
        int yHigh;
        currenttip = super.handleTooltip(gui, currenttip, id);
        Point mouse = this.getMouse(this.getGuiWidth(gui), this.getGuiHeight(gui));
        if (this.isOverItem(gui, id)) {
            return currenttip;
        }
        CachedCasterRecipe cache = (CachedCasterRecipe)((Object)this.arecipes.get(id));
        String fluid = StringHelper.getFluidName(cache.fluid);
        int yLow = id % 2 == 0 ? 26 : 89;
        int n = yHigh = id % 2 == 0 ? 73 : 138;
        if (mouse.x >= 20 && mouse.x <= 68 && mouse.y >= yLow && mouse.y <= yHigh) {
            currenttip.add(fluid);
            StringHelper.getFluidQty(currenttip, cache.fluid, -1);
        }
        return currenttip;
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int id) {
        int yHigh;
        super.mouseClicked(gui, button, id);
        Point mouse = this.getMouse(this.getGuiWidth(gui), this.getGuiHeight(gui));
        if (this.isOverItem(gui, id)) {
            return false;
        }
        CachedCasterRecipe cache = (CachedCasterRecipe)((Object)this.arecipes.get(id));
        int yLow = id % 2 == 0 ? 26 : 89;
        int n = yHigh = id % 2 == 0 ? 73 : 138;
        if (mouse.x >= 20 && mouse.x <= 68 && mouse.y >= yLow && mouse.y <= yHigh) {
            this.loadFluidsButton(button, cache.fluid);
        }
        return false;
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int id) {
        int yHigh;
        super.keyTyped(gui, keyChar, keyCode, id);
        Point mouse = this.getMouse(this.getGuiWidth(gui), this.getGuiHeight(gui));
        if (this.isOverItem(gui, id)) {
            return false;
        }
        CachedCasterRecipe cache = (CachedCasterRecipe)((Object)this.arecipes.get(id));
        int yLow = id % 2 == 0 ? 26 : 89;
        int n = yHigh = id % 2 == 0 ? 73 : 138;
        if (mouse.x >= 20 && mouse.x <= 68 && mouse.y >= yLow && mouse.y <= yHigh) {
            this.loadFluidsKey(keyCode, cache.fluid);
        }
        return false;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(77, 26, 22, 16), this.getOverlayIdentifier(), new Object[0]));
    }

    public abstract String getOverlayIdentifier();

    public abstract Class thisClass();

    public abstract HashMap<String, RecipeCasting> getRecipes();

    public abstract String getRecipeName();

    public abstract String getGuiTexture();

    public abstract FeatureTank.TankSize getTankType();

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)15, (int)166, (int)73);
        this.drawExtras(recipe);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GuiDraw.changeTexture((String)this.getGuiTexture());
    }

    @Override
    public boolean isOverItem(GuiRecipe gui, int id) {
        CachedCasterRecipe cache = (CachedCasterRecipe)((Object)this.arecipes.get(id));
        return cache.output != null && gui.isMouseOver(cache.output, id);
    }

    public class CachedCasterRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        FluidStack fluid;
        PositionedStack output;

        public CachedCasterRecipe(FluidStack fluid, ItemStack output) {
            super((TemplateRecipeHandler)NEICastingRecipeHandler.this);
            this.fluid = fluid.copy();
            this.output = new PositionedStack((Object)output.func_77946_l(), 119, 25);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public PositionedStack getIngredient() {
            return null;
        }
    }
}

