/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.logging.Level;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeSmelter;
import mariculture.core.Core;
import mariculture.core.handlers.LogHandler;
import mariculture.core.lib.ItemIds;
import mariculture.core.lib.Items;
import mariculture.core.lib.MetalRates;
import mariculture.core.util.FluidDictionary;
import mariculture.plugins.Plugins;
import mariculture.plugins.tconstruct.ModPearl;
import mariculture.plugins.tconstruct.TiCEvents;
import mariculture.plugins.tconstruct.TitaniumPart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.client.TConstructClientRegistry;
import tconstruct.library.crafting.FluidType;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.crafting.Smeltery;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.HarvestTool;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMod;

public class PluginTConstruct
extends Plugins.Plugin {
    public static final int titanium_id = 200;
    public static TitaniumPart arrowhead;
    public static TitaniumPart axe_head;
    public static TitaniumPart battle_sign_head;
    public static TitaniumPart binding;
    public static TitaniumPart broad_axe_head;
    public static TitaniumPart chisel_head;
    public static TitaniumPart chunk;
    public static TitaniumPart crossbar;
    public static TitaniumPart excavator_head;
    public static TitaniumPart frypan_head;
    public static TitaniumPart full_guard;
    public static TitaniumPart hammer_head;
    public static TitaniumPart hand_guard;
    public static TitaniumPart knife_blade;
    public static TitaniumPart large_guard;
    public static TitaniumPart large_sword_blade;
    public static TitaniumPart large_plate;
    public static TitaniumPart pickaxe_head;
    public static TitaniumPart scythe_head;
    public static TitaniumPart shovel_head;
    public static TitaniumPart sword_blade;
    public static TitaniumPart tool_rod;
    public static TitaniumPart tough_binding;
    public static TitaniumPart tough_rod;

    @Override
    public void preInit() {
        try {
            FluidDictionary.instance.addFluid("aluminum.molten", FluidType.Aluminum.fluid);
            FluidDictionary.instance.addFluid("bronze.molten", FluidType.Bronze.fluid);
            FluidDictionary.instance.addFluid("copper.molten", FluidType.Copper.fluid);
            FluidDictionary.instance.addFluid("glass.molten", FluidType.Glass.fluid);
            FluidDictionary.instance.addFluid("gold.molten", FluidType.Gold.fluid);
            FluidDictionary.instance.addFluid("iron.molten", FluidType.Iron.fluid);
            FluidDictionary.instance.addFluid("lead.molten", FluidType.Lead.fluid);
            FluidDictionary.instance.addFluid("nickel.molten", FluidType.Nickel.fluid);
            FluidDictionary.instance.addFluid("silver.molten", FluidType.Silver.fluid);
            FluidDictionary.instance.addFluid("steel.molten", FluidType.Steel.fluid);
            FluidDictionary.instance.addFluid("tin.molten", FluidType.Tin.fluid);
            FluidDictionary.instance.addFluid("electrum.molten", FluidType.Electrum.fluid);
            FluidDictionary.instance.addFluid("cobalt.molten", FluidType.Cobalt.fluid);
            MinecraftForge.EVENT_BUS.register((Object)new TiCEvents());
        }
        catch (Exception e) {
            LogHandler.log(Level.SEVERE, "Mariculture will NOT use Tinkers constructs molten fluids due to an error on load");
            e.printStackTrace();
        }
    }

    @Override
    public void init() {
        arrowhead = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_1).func_77655_b("titanium.arrow.head");
        axe_head = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_2).func_77655_b("titanium.axe.head");
        battle_sign_head = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_3).func_77655_b("titanium.battlesign.head");
        binding = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_4).func_77655_b("titanium.binding");
        chisel_head = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_5).func_77655_b("titanium.chisel.head");
        chunk = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_6).func_77655_b("titanium.chunk");
        crossbar = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_7).func_77655_b("titanium.crossbar");
        excavator_head = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_8).func_77655_b("titanium.excavator.head");
        frypan_head = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_9).func_77655_b("titanium.frypan.head");
        full_guard = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_10).func_77655_b("titanium.full.guard");
        hammer_head = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_11).func_77655_b("titanium.hammer.head");
        knife_blade = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_12).func_77655_b("titanium.knife.blade");
        large_guard = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_13).func_77655_b("titanium.large.guard");
        large_sword_blade = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_14).func_77655_b("titanium.large.sword.blade");
        large_plate = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_15).func_77655_b("titanium.large.plate");
        broad_axe_head = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_16).func_77655_b("titanium.lumberaxe.head");
        hand_guard = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_17).func_77655_b("titanium.medium.guard");
        pickaxe_head = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_18).func_77655_b("titanium.pickaxe.head");
        scythe_head = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_19).func_77655_b("titanium.scythe.head");
        shovel_head = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_20).func_77655_b("titanium.shovel.head");
        sword_blade = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_21).func_77655_b("titanium.sword.blade");
        tool_rod = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_22).func_77655_b("titanium.tool.rod");
        tough_binding = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_23).func_77655_b("titanium.tough.binding");
        tough_rod = (TitaniumPart)new TitaniumPart(ItemIds.titanium_part_24).func_77655_b("titanium.tough.rod");
        GameRegistry.registerItem((Item)arrowhead, (String)"titanium_arrow_head");
        GameRegistry.registerItem((Item)axe_head, (String)"titanium_axe_head");
        GameRegistry.registerItem((Item)battle_sign_head, (String)"titanium_battle_sign");
        GameRegistry.registerItem((Item)binding, (String)"titanium_binding");
        GameRegistry.registerItem((Item)broad_axe_head, (String)"titanium_broad_axe_head");
        GameRegistry.registerItem((Item)chisel_head, (String)"titanium_chisel_head");
        GameRegistry.registerItem((Item)chunk, (String)"titanium_chunk");
        GameRegistry.registerItem((Item)crossbar, (String)"titanium_crossbar");
        GameRegistry.registerItem((Item)excavator_head, (String)"titanium_excavator_head");
        GameRegistry.registerItem((Item)frypan_head, (String)"titanium_frypan_head");
        GameRegistry.registerItem((Item)full_guard, (String)"titanium_full_guard");
        GameRegistry.registerItem((Item)hammer_head, (String)"titanium_hammer_head");
        GameRegistry.registerItem((Item)hand_guard, (String)"titanium_hand_guard");
        GameRegistry.registerItem((Item)knife_blade, (String)"titanium_knife_blade");
        GameRegistry.registerItem((Item)large_guard, (String)"titanium_large_guard");
        GameRegistry.registerItem((Item)large_sword_blade, (String)"titanium_large_swordBlade");
        GameRegistry.registerItem((Item)large_plate, (String)"titanium_large_plate");
        GameRegistry.registerItem((Item)pickaxe_head, (String)"titanium_pickaxe_head");
        GameRegistry.registerItem((Item)scythe_head, (String)"titanium_scythe_head");
        GameRegistry.registerItem((Item)shovel_head, (String)"titanium_shovel_head");
        GameRegistry.registerItem((Item)sword_blade, (String)"titanium_sword_blade");
        GameRegistry.registerItem((Item)tool_rod, (String)"titanium_tool_rod");
        GameRegistry.registerItem((Item)tough_binding, (String)"titanium_tough_binding");
        GameRegistry.registerItem((Item)tough_rod, (String)"titanium_tough_rod");
    }

    @Override
    public void postInit() {
        int level = Loader.isModLoaded((String)"IguanaTweaks") ? 5 : 4;
        TConstructRegistry.addToolMaterial((int)200, (String)"Titanium", (int)level, (int)600, (int)1500, (int)2, (float)1.5f, (int)2, (float)0.0f, (String)"", (String)"");
        TConstructClientRegistry.addMaterialRenderMapping((int)200, (String)"Mariculture", (String)"titanium", (boolean)true);
        TConstructRegistry.addBowMaterial((int)200, (int)768, (int)40, (float)1.2f);
        TConstructRegistry.addArrowMaterial((int)200, (float)5.0f, (float)0.25f, (float)100.0f);
        this.addMelting();
        this.addTools();
        this.addAlloy();
        this.addModifiers();
    }

    public void addMelting() {
        this.addMelting("ingotRutile", new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.rutile), MetalRates.INGOT), 800);
        this.addMelting("ingotTitanium", new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.titanium), MetalRates.INGOT), 800);
        this.addMelting("oreRutile", new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.rutile), MetalRates.ORE), 800);
        this.addMelting("dustTitanium", new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.titanium), MetalRates.INGOT), 800);
        this.addMelting("blockTitanium", new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.titanium), MetalRates.BLOCK), 800);
        this.addMelting("nuggetTitanium", new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.titanium), MetalRates.NUGGET), 800);
        this.addCasting("ingotRutile", new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.rutile), MetalRates.INGOT), 100);
        this.addCasting("ingotTitanium", new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.titanium), MetalRates.INGOT), 100);
        this.addBlockCasting("blockTitanium", new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.titanium), MetalRates.BLOCK), 100);
        this.addMelting("ingotMagnesium", new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.magnesium), MetalRates.INGOT), 300);
        this.addMelting("oreMagnesium", new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.magnesium), MetalRates.ORE), 300);
        this.addMelting("dustMagnesium", new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.magnesium), MetalRates.INGOT), 300);
        this.addMelting("blockMagnesium", new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.magnesium), MetalRates.BLOCK), 300);
        this.addMelting("nuggetMagnesium", new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.magnesium), MetalRates.NUGGET), 300);
        Smeltery.addMelting((ItemStack)Items.dustMagnesium, (int)300, (FluidStack)FluidDictionary.getFluidStack(FluidDictionary.magnesium, MetalRates.INGOT));
        this.addCasting("ingotMagnesium", new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.magnesium), MetalRates.INGOT), 100);
        this.addBlockCasting("blockMagnesium", new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.magnesium), MetalRates.BLOCK), 100);
        this.addMelting("blockLimestone", FluidDictionary.getFluidStack(FluidDictionary.quicklime, 900), 100);
        this.addMelting("limestone", FluidDictionary.getFluidStack(FluidDictionary.quicklime, 900), 100);
        this.addCastings(200, new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.titanium), MetalRates.INGOT), 80);
        if (OreDictionary.getOres((String)"ingotTitanium").size() > 0) {
            for (ItemStack ingot : OreDictionary.getOres((String)"ingotTitanium")) {
                PatternBuilder.instance.registerFullMaterial(ingot, 2, "Titanium", new ItemStack((Item)chunk, 1, 200), new ItemStack((Item)tool_rod, 1, 200), 200);
            }
        }
    }

    public void addTools() {
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"arrow")), (Item[])new Item[]{arrowhead, tool_rod, TConstructRegistry.getItem((String)"fletching")});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"battleaxe")), (Item[])new Item[]{broad_axe_head, tough_rod, broad_axe_head, tough_binding});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"battlesign")), (Item[])new Item[]{battle_sign_head, tool_rod});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"broadsword")), (Item[])new Item[]{sword_blade, tool_rod, large_guard});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"chisel")), (Item[])new Item[]{chisel_head, tool_rod});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"cleaver")), (Item[])new Item[]{large_sword_blade, tough_rod, large_plate, tough_rod});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"cutlass")), (Item[])new Item[]{sword_blade, tool_rod, full_guard});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"dagger")), (Item[])new Item[]{knife_blade, tool_rod, crossbar});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"excavator")), (Item[])new Item[]{excavator_head, tough_rod, large_plate, tough_binding});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"frypan")), (Item[])new Item[]{frypan_head, tool_rod});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"hammer")), (Item[])new Item[]{hammer_head, tough_rod, large_plate, large_plate});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"hatchet")), (Item[])new Item[]{axe_head, tool_rod});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"longsword")), (Item[])new Item[]{sword_blade, tool_rod, hand_guard});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"lumberaxe")), (Item[])new Item[]{broad_axe_head, tough_rod, large_plate, tough_binding});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"mattock")), (Item[])new Item[]{axe_head, tool_rod, shovel_head});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"pickaxe")), (Item[])new Item[]{pickaxe_head, tool_rod, binding});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"rapier")), (Item[])new Item[]{sword_blade, tool_rod, crossbar});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"scythe")), (Item[])new Item[]{scythe_head, tough_rod, tough_binding, tough_rod});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"shortbow")), (Item[])new Item[]{tool_rod, TConstructRegistry.getItem((String)"bowstring"), tool_rod});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"shortbow")), (Item[])new Item[]{TConstructRegistry.getItem((String)"toolRod"), TConstructRegistry.getItem((String)"bowstring"), tool_rod});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"shortbow")), (Item[])new Item[]{tool_rod, TConstructRegistry.getItem((String)"bowstring"), TConstructRegistry.getItem((String)"toolRod")});
        TConstructRegistry.addToolRecipe((ToolCore)((ToolCore)TConstructRegistry.getItem((String)"shovel")), (Item[])new Item[]{shovel_head, tool_rod});
    }

    private void addAlloy() {
        FluidStack titanium = new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.titanium), 8);
        FluidStack rutile = new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.rutile), 8);
        FluidStack magnesium = new FluidStack(FluidRegistry.getFluid((String)FluidDictionary.magnesium), 8);
        Smeltery.addAlloyMixing((FluidStack)titanium, (FluidStack[])new FluidStack[]{rutile, magnesium});
    }

    private void addModifiers() {
        ToolBuilder tb = ToolBuilder.instance;
        ItemStack pearl = new ItemStack(Core.pearls, 1, Short.MAX_VALUE);
        ItemStack pearlBlock = new ItemStack(Core.pearl, 1, Short.MAX_VALUE);
        int effect = 20;
        ToolBuilder.registerToolMod((ToolMod)new ModPearl(new ItemStack[]{pearl}, effect, 1));
        ToolBuilder.registerToolMod((ToolMod)new ModPearl(new ItemStack[]{pearl, pearl}, effect, 2));
        ToolBuilder.registerToolMod((ToolMod)new ModPearl(new ItemStack[]{pearlBlock}, effect, 4));
        ToolBuilder.registerToolMod((ToolMod)new ModPearl(new ItemStack[]{pearl, pearlBlock}, effect, 5));
        ToolBuilder.registerToolMod((ToolMod)new ModPearl(new ItemStack[]{pearlBlock, pearlBlock}, effect, 8));
        for (ToolCore tool : TConstructRegistry.getToolMapping()) {
            if (!(tool instanceof HarvestTool)) continue;
            TConstructClientRegistry.addEffectRenderMapping((ToolCore)tool, (int)effect, (String)"mariculture", (String)"pearl", (boolean)true);
        }
        if (FluidRegistry.getFluid((String)"xpjuice") != null) {
            ItemStack xpberry = TConstructRegistry.getItemStack((String)"oreberryEssence");
            ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
            ArrayList<Integer> chances = new ArrayList<Integer>();
            int j = 3;
            for (int i = 80; i <= 120; i += 10) {
                chances.add(j);
                fluids.add(FluidRegistry.getFluidStack((String)"xpjuice", (int)i));
                ++j;
            }
            MaricultureHandlers.smelter.addRecipe(new RecipeSmelter(xpberry, 1000, fluids.toArray(new FluidStack[fluids.size()]), chances.toArray(new Integer[chances.size()]), null, 0));
        }
    }

    private void addCasting(String dic, FluidStack fluid, int delay) {
        if (OreDictionary.getOres((String)dic).size() > 0) {
            TConstructRegistry.getTableCasting().addCastingRecipe((ItemStack)OreDictionary.getOres((String)dic).get(0), fluid, TConstructRegistry.getItemStack((String)"ingotCast"), delay);
        }
    }

    private void addCastings(int id, FluidStack fluid, int delay) {
        this.addPartCasting(new ItemStack((Item)tool_rod, 1, id), TConstructRegistry.getItemStack((String)"toolRodCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)pickaxe_head, 1, id), TConstructRegistry.getItemStack((String)"pickaxeHeadCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)shovel_head, 1, id), TConstructRegistry.getItemStack((String)"shovelHeadCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)axe_head, 1, id), TConstructRegistry.getItemStack((String)"hatchetHeadCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)sword_blade, 1, id), TConstructRegistry.getItemStack((String)"swordBladeCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)large_guard, 1, id), TConstructRegistry.getItemStack((String)"wideGuardCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)hand_guard, 1, id), TConstructRegistry.getItemStack((String)"handGuardCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)crossbar, 1, id), TConstructRegistry.getItemStack((String)"crossBarCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)binding, 1, id), TConstructRegistry.getItemStack((String)"bindingCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)frypan_head, 1, id), TConstructRegistry.getItemStack((String)"frypanHeadCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)battle_sign_head, 1, id), TConstructRegistry.getItemStack((String)"signHeadCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)knife_blade, 1, id), TConstructRegistry.getItemStack((String)"knifeBladeCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)chisel_head, 1, id), TConstructRegistry.getItemStack((String)"chiselHeadCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)tough_rod, 1, id), TConstructRegistry.getItemStack((String)"toughRodCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)tough_binding, 1, id), TConstructRegistry.getItemStack((String)"toughBindingCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)large_plate, 1, id), TConstructRegistry.getItemStack((String)"largePlateCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)broad_axe_head, 1, id), TConstructRegistry.getItemStack((String)"broadAxeHeadCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)scythe_head, 1, id), TConstructRegistry.getItemStack((String)"scytheHeadCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)excavator_head, 1, id), TConstructRegistry.getItemStack((String)"excavatorHeadCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)large_sword_blade, 1, id), TConstructRegistry.getItemStack((String)"largeBladeCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)hammer_head, 1, id), TConstructRegistry.getItemStack((String)"hammerHeadCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)full_guard, 1, id), TConstructRegistry.getItemStack((String)"fullGuardCast"), fluid, delay);
        this.addPartCasting(new ItemStack((Item)arrowhead, 1, id), new ItemStack(TConstructRegistry.getItem((String)"metalPattern"), 1, 25), fluid, delay);
    }

    private void addMelting(String dic, FluidStack fluid, int temp) {
        if (OreDictionary.getOres((String)dic).size() > 0) {
            for (ItemStack ore : OreDictionary.getOres((String)dic)) {
                Smeltery.addMelting((ItemStack)ore, (int)temp, (FluidStack)fluid);
            }
        }
    }

    private void addBlockCasting(String dic, FluidStack fluid, int delay) {
        if (OreDictionary.getOres((String)dic).size() > 0) {
            TConstructRegistry.getBasinCasting().addCastingRecipe((ItemStack)OreDictionary.getOres((String)dic).get(0), fluid, delay);
        }
    }

    private void addPartCasting(ItemStack output, ItemStack cast, FluidStack fluid, int hardeningDelay) {
        TConstructRegistry.getTableCasting().addCastingRecipe(output, fluid, cast, hardeningDelay);
    }
}

