/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins;

import biomesoplenty.api.Biomes;
import biomesoplenty.api.Blocks;
import com.google.common.base.Optional;
import mariculture.api.core.Environment;
import mariculture.api.core.MaricultureHandlers;
import mariculture.core.lib.WorldGeneration;
import mariculture.plugins.Plugins;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.oredict.OreDictionary;

public class PluginBiomesOPlenty
extends Plugins.Plugin {
    private void addBiome(Optional<? extends BiomeGenBase> biome, int temp, Environment.Salinity salt) {
        if (biome.isPresent()) {
            MaricultureHandlers.environment.addEnvironment((BiomeGenBase)biome.get(), salt, temp);
        }
    }

    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.alps, -5, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.alpsForest, -1, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.alpsBase, 0, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.arctic, -1, Environment.Salinity.SALINE);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.badlands, 35, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.bambooForest, 20, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.bayou, 15, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.beachGravel, 20, Environment.Salinity.BRACKISH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.beachOvergrown, 26, Environment.Salinity.BRACKISH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.birchForest, 10, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.bog, 7, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.brushland, 30, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.canyon, 40, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.canyonRavine, 40, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.chaparral, 6, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.cherryBlossomGrove, 12, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.coniferousForest, 5, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.coniferousForestSnow, 2, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.crag, 40, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.deadForest, 40, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.deadForestSnow, 5, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.deadSwamp, 7, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.deadlands, 65, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.deciduousForest, 8, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.dunes, 50, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.fen, 12, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.field, 11, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.fieldForest, 10, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.frostForest, 3, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.fungiForest, 6, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.grassland, 10, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.glacier, 0, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.grove, 10, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.heathland, 7, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.highland, 6, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.hotSprings, 14, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.icyHills, 2, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.jadeCliffs, 13, Environment.Salinity.BRACKISH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.lushDesert, 37, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.lushSwamp, 8, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.mangrove, 20, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.mapleWoods, 12, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.marsh, 7, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.meadow, 10, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.meadowForest, 9, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.mesa, 36, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.moor, 3, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.mountain, 0, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.mysticGrove, 10, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.netherBase, 80, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.netherGarden, 78, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.netherDesert, 90, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.netherLava, 100, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.netherBone, 79, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.oasis, 22, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.oceanCoral, 26, Environment.Salinity.SALINE);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.oceanKelp, 24, Environment.Salinity.SALINE);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.ominousWoods, 8, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.ominousWoodsThick, 7, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.orchard, 10, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.originValley, 11, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.outback, 24, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.overgrownGreens, 8, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.pasture, 10, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.pastureMeadow, 11, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.pastureThin, 9, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.polar, -1, Environment.Salinity.SALINE);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.prairie, 20, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.promisedLandForest, 9, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.promisedLandPlains, 10, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.promisedLandSwamp, 8, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.quagmire, 9, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.rainforest, 25, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.redwoodForest, 5, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.sacredSprings, 14, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.savanna, 28, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.savannaPlateau, 30, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.scrubland, 32, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.seasonalForest, 10, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.seasonalSpruceForest, 7, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.shield, 8, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.shore, 4, Environment.Salinity.BRACKISH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.shrubland, 17, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.shrublandForest, 15, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.silkglades, 20, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.sludgepit, 15, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.spruceWoods, 8, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.steppe, 20, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.temperateRainforest, 15, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.thicket, 10, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.timber, 7, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.timberThin, 6, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.tropicalRainforest, 28, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.tropics, 27, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.tundra, 1, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.volcano, 75, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.wasteland, 40, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.wetland, 8, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.woodland, 10, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.plainsNew, 10, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.desertNew, 45, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.extremeHillsNew, 5, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.forestNew, 10, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.taigaNew, 1, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.taigaHillsNew, 0, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.swamplandNew, 8, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.jungleNew, 25, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.jungleHillsNew, 24, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.autumnHills, 5, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.lavenderFields, 10, Environment.Salinity.FRESH);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.oceanAbyss, 1, Environment.Salinity.SALINE);
        this.addBiome((Optional<? extends BiomeGenBase>)Biomes.tropicsMountain, 20, Environment.Salinity.FRESH);
        if (Blocks.coral.isPresent()) {
            int id = ((Block)Blocks.coral.get()).field_71990_ca;
            OreDictionary.registerOre((String)"plantKelp", (ItemStack)new ItemStack(id, 1, 3));
            OreDictionary.registerOre((String)"coralPink", (ItemStack)new ItemStack(id, 1, 4));
            OreDictionary.registerOre((String)"coralOrange", (ItemStack)new ItemStack(id, 1, 5));
            OreDictionary.registerOre((String)"coralLightBlue", (ItemStack)new ItemStack(id, 1, 6));
            OreDictionary.registerOre((String)"coralPurple", (ItemStack)new ItemStack(id, 1, 7));
        }
    }

    @Override
    public void postInit() {
        WorldGeneration.CORAL_CHANCE /= 5;
        WorldGeneration.KELP_HEIGHT = (int)((double)WorldGeneration.KELP_HEIGHT * 2.5);
        WorldGeneration.KELP_CHANCE /= 3;
    }

    public static boolean isBiome(World world, int x, int z, Biome biome) {
        Optional biomeType;
        WorldType worldType = world.func_72912_H().func_76067_t();
        boolean isVanilla = true;
        if (biome.equals((Object)Biome.CORAL)) {
            for (String type : WorldGeneration.CORAL_BIOMESOP_TYPES) {
                if (worldType != WorldType.func_77130_a((String)type)) continue;
                isVanilla = false;
                break;
            }
        }
        if (biome.equals((Object)Biome.KELP)) {
            for (String type : WorldGeneration.KELP_BIOMESOP_TYPES) {
                if (worldType != WorldType.func_77130_a((String)type)) continue;
                isVanilla = false;
                break;
            }
        }
        if (isVanilla) {
            return true;
        }
        if (biome.equals((Object)Biome.KELP) && !WorldGeneration.KELP_BIOMESOP) {
            return true;
        }
        if (biome.equals((Object)Biome.CORAL) && !WorldGeneration.CORAL_BIOMESOP) {
            return true;
        }
        Optional optional = biomeType = biome.equals((Object)Biome.KELP) ? Biomes.oceanKelp : Biomes.oceanCoral;
        return !biomeType.isPresent() || world.func_72959_q().func_76935_a(x, z) == biomeType.get();
    }

    public static enum Biome {
        KELP,
        CORAL;

    }
}

