/*
 * Decompiled with CFR 0.152.
 */
package mariculture.magic;

import java.util.logging.Level;
import mariculture.core.handlers.LogHandler;
import mariculture.core.lib.Extra;
import mariculture.magic.MirrorData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;

public class MirrorHelper {
    private static final MirrorHelper INSTANCE = new MirrorHelper();

    public static MirrorHelper instance() {
        return INSTANCE;
    }

    public MirrorData getData(EntityPlayer player) {
        String check = "Mariculture-Mirror-" + (Extra.JEWELRY_OFFLINE ? "PlayerOffline" : player.field_71092_bJ);
        MirrorData data = (MirrorData)player.field_70170_p.func_72943_a(MirrorData.class, check);
        if (data == null) {
            data = new MirrorData(check);
            player.field_70170_p.func_72823_a(check, (WorldSavedData)data);
        }
        return data;
    }

    public ItemStack[] get(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && player != null) {
            MirrorData data = this.getData(player);
            if (data.getJewelry() == null) {
                NBTTagCompound loader = player.getEntityData().func_74775_l("PlayerPersisted");
                NBTTagList nbttaglist = loader.func_74761_m("mirrorContents");
                if (nbttaglist != null) {
                    ItemStack[] mirrorContents = new ItemStack[4];
                    for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                        NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
                        byte byte0 = nbttagcompound1.func_74771_c("Slot");
                        if (byte0 < 0 || byte0 >= mirrorContents.length) continue;
                        mirrorContents[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
                    }
                    player.getEntityData().func_74775_l("PlayerPersisted").func_82580_o("mirrorContents");
                    return data.setJewelry(mirrorContents);
                }
                return data.setJewelry(new ItemStack[4]);
            }
            return data.getJewelry();
        }
        return new ItemStack[4];
    }

    public void save(EntityPlayer player, ItemStack[] mirrorContents) {
        if (!player.field_70170_p.field_72995_K && player != null) {
            try {
                this.getData(player).setJewelry(mirrorContents);
            }
            catch (Exception e) {
                LogHandler.log(Level.WARNING, "Mariculture had trouble saving Mirror Contents for " + player.field_71092_bJ);
            }
        }
    }
}

