/*
 * Decompiled with CFR 0.152.
 */
package mariculture.magic;

import java.util.Random;
import mariculture.api.core.MaricultureHandlers;
import mariculture.core.helpers.EnchantHelper;
import mariculture.core.helpers.cofh.ItemHelper;
import mariculture.magic.Magic;
import mariculture.magic.enchantments.EnchantmentBlink;
import mariculture.magic.enchantments.EnchantmentClock;
import mariculture.magic.enchantments.EnchantmentFallDamage;
import mariculture.magic.enchantments.EnchantmentFire;
import mariculture.magic.enchantments.EnchantmentGlide;
import mariculture.magic.enchantments.EnchantmentJump;
import mariculture.magic.enchantments.EnchantmentOneRing;
import mariculture.magic.enchantments.EnchantmentPoison;
import mariculture.magic.enchantments.EnchantmentPunch;
import mariculture.magic.enchantments.EnchantmentResurrection;
import mariculture.magic.enchantments.EnchantmentSpeed;
import mariculture.magic.enchantments.EnchantmentSpider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;

public class MagicEventHandler {
    private Random rand = new Random();

    @ForgeSubscribe
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            World world = event.entity.field_70170_p;
            EntityPlayer player = (EntityPlayer)event.entity;
            if (world.field_72995_K) {
                if (EnchantHelper.exists(Magic.glide)) {
                    EnchantmentGlide.activate(player);
                }
                if (EnchantHelper.exists(Magic.speed)) {
                    EnchantmentSpeed.activate(player);
                }
                if (EnchantHelper.exists(Magic.spider)) {
                    EnchantmentSpider.activate(player);
                }
            } else if (EnchantHelper.exists(Magic.oneRing)) {
                EnchantmentOneRing.activate((EntityPlayer)event.entity);
            }
        }
    }

    @ForgeSubscribe
    public void onEntityJump(LivingEvent.LivingJumpEvent event) {
        if (EnchantHelper.exists(Magic.jump) && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (player.field_70170_p.field_72995_K) {
                EnchantmentJump.activate(player);
            }
        }
    }

    @ForgeSubscribe
    public void onEntityFall(LivingFallEvent event) {
        if ((EnchantHelper.exists(Magic.glide) || EnchantHelper.exists(Magic.fall) || EnchantHelper.exists(Magic.flight)) && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (!player.field_70170_p.field_72995_K) {
                EnchantmentGlide.damage(player, this.rand);
                EnchantmentFallDamage.activate(event);
                if (EnchantHelper.hasEnchantment(Magic.flight, player)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @ForgeSubscribe
    public void onLivingHurt(LivingHurtEvent event) {
        if (EnchantHelper.exists(Magic.fire) && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            EnchantmentFire.testForFireDamage(event);
        }
    }

    @ForgeSubscribe
    public void onLivingAttack(LivingAttackEvent event) {
        if (EnchantHelper.exists(Magic.fire) && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            EnchantmentFire.activate(player, event);
        }
    }

    @ForgeSubscribe
    public void onAttackEntity(AttackEntityEvent event) {
        if (EnchantHelper.exists(Magic.fire) || EnchantHelper.exists(Magic.poison) || EnchantHelper.exists(Magic.punch)) {
            EntityPlayer player = event.entityPlayer;
            Entity target = event.target;
            if (!player.field_70170_p.field_72995_K && MaricultureHandlers.mirror.containsEnchantedItems(player)) {
                EnchantmentFire.onAttack(player, target);
                EnchantmentPoison.onAttack(player, target);
                EnchantmentPunch.onAttack(player, target);
            }
        }
    }

    @ForgeSubscribe
    public void onEntityInteract(EntityInteractEvent event) {
        if (EnchantHelper.exists(Magic.fire) || EnchantHelper.exists(Magic.poison)) {
            EntityPlayer player = (EntityPlayer)event.entity;
            Entity target = event.target;
            if (!player.field_70170_p.field_72995_K && MaricultureHandlers.mirror.containsEnchantedItems(player)) {
                EnchantmentFire.onRightClick(player, target);
                EnchantmentPoison.onRightClick(player, target);
            }
        }
    }

    @ForgeSubscribe
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (EnchantHelper.exists(Magic.blink) && event.entityPlayer.field_70170_p.field_72995_K && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
            EnchantmentBlink.sendPacket(event.entityPlayer);
        }
    }

    @ForgeSubscribe
    public void onWorldUpdate(WorldEvent event) {
        if (EnchantHelper.exists(Magic.clock)) {
            World world = event.world;
            if (!world.field_72995_K && world.field_73011_w.func_76569_d()) {
                if (world.func_72935_r()) {
                    EnchantmentClock.activate(world, 1, 18000);
                } else {
                    EnchantmentClock.activate(world, 0, 6000);
                }
            }
        }
    }

    @ForgeSubscribe
    public void onEntityDeath(LivingDeathEvent event) {
        if (event.source.func_76364_f() != null && event.source.func_76364_f() instanceof EntityPlayer) {
            ItemStack magnet;
            EntityLivingBase entity = event.entityLiving;
            EntityPlayer player = (EntityPlayer)event.source.func_76364_f();
            if (!(entity instanceof EntityPlayer) && ItemHelper.isPlayerHoldingItem(Magic.magnet, player) && !(magnet = player.func_71045_bC()).func_77942_o()) {
                magnet.func_77982_d(new NBTTagCompound());
                magnet.field_77990_d.func_74778_a("MobClass", entity.getClass().toString().substring(6));
                magnet.field_77990_d.func_74778_a("MobName", entity.func_70023_ak());
            }
        }
    }

    @ForgeSubscribe
    public void onPlayerDeath(LivingDeathEvent event) {
        if (EnchantHelper.exists(Magic.resurrection)) {
            EnchantmentResurrection.activate(event);
        }
    }
}

