/*
 * Decompiled with CFR 0.152.
 */
package mariculture.magic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mariculture.Mariculture;
import mariculture.api.core.MaricultureTab;
import mariculture.core.gui.InventoryStorage;
import mariculture.core.helpers.OreDicHelper;
import mariculture.core.items.ItemStorage;
import mariculture.core.util.Rand;
import mariculture.magic.MirrorHelper;
import mariculture.magic.gui.ContainerMirror;
import mariculture.magic.gui.GuiMirror;
import mariculture.magic.jewelry.ItemJewelry;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ItemMirror
extends ItemStorage {
    public final String name;

    public ItemMirror(int id, String img) {
        super(id, 4, "mirror");
        this.func_77656_e(100);
        this.name = img;
        this.func_77637_a(MaricultureTab.tabJewelry);
    }

    @Override
    public Slot getSlot(InventoryStorage storage, int i) {
        switch (i) {
            case 0: {
                return new SlotJewelry(storage, i, 8, 10, 0);
            }
            case 1: {
                return new SlotJewelry(storage, i, 8, 32, 1);
            }
            case 2: {
                return new SlotJewelry(storage, i, 8, 54, 2);
            }
            case 3: {
                return new Slot((IInventory)storage, i, 35, 47);
            }
        }
        return new Slot((IInventory)storage, i, 100, 100);
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (stack != null) {
            if (!player.func_70093_af()) {
                world.func_72956_a((Entity)player, "mariculture:mirror", 1.0f, 1.0f);
                if (!player.field_71075_bZ.field_75098_d && stack.func_96631_a(1, Rand.rand)) {
                    --stack.field_77994_a;
                } else {
                    player.openGui((Object)Mariculture.instance, 16, world, stack.field_77993_c, 0, 0);
                }
            }
            return stack;
        }
        return null;
    }

    public boolean func_82789_a(ItemStack stack1, ItemStack stack2) {
        return OreDicHelper.getDictionaryName(stack2).equals("ingotAluminum");
    }

    @Override
    public Object getGUIContainer(EntityPlayer player) {
        return new ContainerMirror((IInventory)player.field_71071_by, new InventoryStorage(player, this.size), player.field_70170_p, player.func_71045_bC());
    }

    @Override
    public Object getGUIElement(EntityPlayer player) {
        return new GuiMirror((IInventory)player.field_71071_by, new InventoryStorage(player, this.size), player.field_70170_p, this.gui, player.func_71045_bC());
    }

    @Override
    public ItemStack[] load(EntityPlayer player, ItemStack stack, int size) {
        return MirrorHelper.instance().get(player);
    }

    @Override
    public void save(EntityPlayer player, ItemStack[] inventory) {
        MirrorHelper.instance().save(player, inventory);
    }

    public int func_77619_b() {
        return 10;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("mariculture:" + this.name);
    }

    private class SlotJewelry
    extends Slot {
        private ResourceLocation ring;
        private ResourceLocation bracelet;
        private ResourceLocation necklace;
        private int type;
        private Icon[] bgIcons;

        public SlotJewelry(IInventory inv, int id, int x, int y, int type) {
            super(inv, id, x, y);
            this.ring = new ResourceLocation("mariculture:textures/gui/icon_ring.png");
            this.bracelet = new ResourceLocation("mariculture:textures/gui/icon_bracelet.png");
            this.necklace = new ResourceLocation("mariculture:textures/gui/icon_necklace.png");
            this.type = type;
        }

        public boolean func_75214_a(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemJewelry && ((ItemJewelry)stack.func_77973_b()).getType() == this.type;
        }

        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getBackgroundIconTexture() {
            switch (this.type) {
                case 0: {
                    return this.ring;
                }
                case 1: {
                    return this.bracelet;
                }
                case 2: {
                    return this.necklace;
                }
            }
            return this.texture == null ? TextureMap.field_110576_c : this.texture;
        }
    }
}

