/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.items;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mariculture.api.core.MaricultureTab;
import mariculture.api.fishery.ItemBaseRod;
import mariculture.api.fishery.RodQuality;
import mariculture.core.items.ItemBattery;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemFluxRod
extends ItemBaseRod
implements IEnergyContainerItem {
    protected int capacity = 100000;
    protected int maxReceive = 250;
    protected int maxExtract = 100;

    public ItemFluxRod(int i, RodQuality quality) {
        super(i, quality);
        this.setNoRepair();
        this.func_77625_d(1);
        this.func_77637_a(MaricultureTab.tabMariculture);
    }

    public int getDisplayDamage(ItemStack stack) {
        if (stack.field_77990_d == null) {
            return 1 + this.capacity;
        }
        return 1 + this.capacity - stack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack stack) {
        return 1 + this.capacity;
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (stack.field_77990_d == null) {
            return;
        }
        list.add("Charge: " + stack.field_77990_d.func_74762_e("Energy") + " / " + this.capacity + " RF");
        list.add("Transfer: " + this.maxReceive + " RF/t");
        list.add("RF Per Use: " + this.maxExtract + " RF");
        super.func_77624_a(stack, player, list, bool);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77629_n_() {
        return true;
    }

    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("mariculture:" + this.func_77658_a().substring(5));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int j, CreativeTabs creative, List list) {
        ItemStack battery = new ItemStack(j, 1, 0);
        list.add(ItemBattery.make(battery, 0));
        list.add(ItemBattery.make(battery, this.capacity));
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        if (container.field_77990_d.func_74762_e("Energy") <= 0) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, this.maxExtract);
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }

    @Override
    public boolean canFish(World world, int x, int y, int z, EntityPlayer player, ItemStack stack) {
        return ((IEnergyContainerItem)stack.func_77973_b()).getEnergyStored(stack) >= 100;
    }

    @Override
    public ItemStack damage(World world, EntityPlayer player, ItemStack stack, int fish) {
        ((IEnergyContainerItem)stack.func_77973_b()).extractEnergy(stack, 100, false);
        return stack;
    }
}

