/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ForgeDirection;

public class FishStargazer
extends FishSpecies {
    public FishStargazer(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{-1, 5};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.SALINE, Environment.Salinity.BRACKISH};
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public int getLifeSpan() {
        return 15;
    }

    @Override
    public int getFertility() {
        return 750;
    }

    @Override
    public int getWaterRequired() {
        return 85;
    }

    @Override
    public int getAreaOfEffectBonus(ForgeDirection dir) {
        return dir == ForgeDirection.DOWN ? 7 : 0;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletWater, 2.0);
        this.addProduct(Items.dropletPoison, 7.5);
        this.addProduct(Items.dropletEarth, 1.5);
        this.addProduct(Items.fishMeal, 3.0);
    }

    @Override
    public double getFishOilVolume() {
        return 4.725;
    }

    @Override
    public void affectLiving(EntityLivingBase entity) {
        if (entity.field_70170_p.field_73012_v.nextInt(100) == 0) {
            entity.func_70097_a(DamageSource.field_82727_n, 1.0f);
        }
    }

    @Override
    public boolean canWork(int time) {
        return !Environment.Time.isNoon(time);
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.GOOD;
    }

    @Override
    public double getCatchChance(int height, int time) {
        return Environment.Height.isDeep(height) ? 10.0 : 0.0;
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return height < 8 && Environment.Time.isMidnight(time) ? 5.0 : 0.0;
    }
}

