/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;

public class FishSquid
extends FishSpecies {
    public FishSquid(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{3, 20};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.SALINE, Environment.Salinity.BRACKISH};
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public int getLifeSpan() {
        return 5;
    }

    @Override
    public int getFertility() {
        return 2500;
    }

    @Override
    public boolean requiresFood() {
        return true;
    }

    @Override
    public int getWaterRequired() {
        return 20;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletWater, 1.5);
        this.addProduct(Items.ink, 15.0);
    }

    @Override
    public double getFishOilVolume() {
        return 0.0;
    }

    @Override
    public int getFishMealSize() {
        return 0;
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.OLD;
    }

    @Override
    public int getCatchChance() {
        return 10;
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return Environment.Time.isDay(time) ? 75.0 : 45.0;
    }
}

