/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;
import mariculture.core.lib.MaricultureDamage;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class FishPiranha
extends FishSpecies {
    public FishPiranha(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{21, 28};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH};
    }

    @Override
    public boolean isDominant() {
        return true;
    }

    @Override
    public int getLifeSpan() {
        return 10;
    }

    @Override
    public int getFertility() {
        return 5000;
    }

    @Override
    public int getFoodConsumption() {
        return 3;
    }

    @Override
    public int getWaterRequired() {
        return 250;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletWater, 3.0);
        this.addProduct(Items.dropletAqua, 2.5);
        this.addProduct(Items.dropletDestroy, 5.0);
        this.addProduct(Items.dropletEarth, 4.0);
        this.addProduct(Items.rottenFlesh, 15.0);
    }

    @Override
    public double getFishOilVolume() {
        return 3.5;
    }

    @Override
    public int getFishMealSize() {
        return 3;
    }

    @Override
    public void onConsumed(World world, EntityPlayer player) {
        player.func_70690_d(new PotionEffect(Potion.field_76433_i.field_76415_H, 20, 0));
    }

    @Override
    public void affectLiving(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.field_70170_p.field_73013_u > 0) {
                player.func_70097_a(MaricultureDamage.piranha, (float)player.field_70170_p.field_73013_u);
            }
        } else {
            entity.func_70097_a(MaricultureDamage.piranha, 2.0f);
        }
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.FLUX;
    }

    @Override
    public double getCatchChance(int height, int time) {
        return Environment.Time.isDusk(time) ? 35.0 : 3.0;
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return height > 70 && height < 80 && Environment.Time.isDusk(time) ? 5.0 : 0.0;
    }
}

