/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class FishPerch
extends FishSpecies {
    public FishPerch(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{8, 15};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH};
    }

    @Override
    public boolean isDominant() {
        return true;
    }

    @Override
    public int getLifeSpan() {
        return 10;
    }

    @Override
    public int getFertility() {
        return 2300;
    }

    @Override
    public int getWaterRequired() {
        return 25;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletWater, 8.0);
        this.addProduct(Items.dropletEarth, 2.5);
    }

    @Override
    public double getFishOilVolume() {
        return 0.22;
    }

    @Override
    public ItemStack getLiquifiedProduct() {
        return new ItemStack(Item.field_77770_aF);
    }

    @Override
    public int getLiquifiedProductChance() {
        return 5;
    }

    @Override
    public int getFishMealSize() {
        return 3;
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.OLD;
    }

    @Override
    public double getCatchChance(int height, int time) {
        return Environment.Time.isDay(time) ? 25.0 : 0.0;
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return Environment.Height.isHigh(height) ? 15.0 : 0.0;
    }
}

