/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.lib.Items;
import mariculture.core.util.Rand;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class FishEnder
extends FishSpecies {
    public FishEnder(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{0, 5};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH};
    }

    @Override
    public boolean isDominant() {
        return true;
    }

    @Override
    public int getLifeSpan() {
        return 25;
    }

    @Override
    public int getFertility() {
        return 75;
    }

    @Override
    public int getFoodConsumption() {
        return 2;
    }

    @Override
    public int getWaterRequired() {
        return 140;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletEnder, 7.5);
        this.addProduct(Items.enderPearl, 5.0);
    }

    @Override
    public double getFishOilVolume() {
        return 0.45;
    }

    @Override
    public int getFishMealSize() {
        return 2;
    }

    @Override
    public void onConsumed(World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            int y;
            world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "mob.endermen.portal", 1.0f, 1.0f);
            int x = (int)(player.field_70165_t + (double)Rand.rand.nextInt(64) - 32.0);
            int z = (int)(player.field_70161_v + (double)Rand.rand.nextInt(64) - 32.0);
            if (BlockHelper.chunkExists(world, x, z) && world.func_72803_f(x, y = world.func_72825_h(x, z), z) != Material.field_76256_h) {
                world.func_72908_a((double)x, (double)y, (double)z, "mob.endermen.portal", 1.0f, 1.0f);
                player.func_70634_a((double)x, (double)y, (double)z);
                world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "mob.endermen.portal", 1.0f, 1.0f);
            }
        }
    }

    @Override
    public boolean canWork(int time) {
        return !Environment.Time.isNoon(time);
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.SUPER;
    }

    @Override
    public boolean isWorldCorrect(World world) {
        return world.field_73011_w.field_76574_g == 1;
    }

    @Override
    public int getCatchChance() {
        return 66;
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return (double)height < 16.0 ? 10.0 : 0.0;
    }
}

