/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class FishDragon
extends FishSpecies {
    public FishDragon(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{-1, 100};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH, Environment.Salinity.BRACKISH};
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public int getLifeSpan() {
        return 60;
    }

    @Override
    public int getFertility() {
        return 10;
    }

    @Override
    public int getBaseProductivity() {
        return 0;
    }

    @Override
    public int getFoodConsumption() {
        return 3;
    }

    @Override
    public int getWaterRequired() {
        return 400;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletEnder, 20.0);
        this.addProduct(Items.enderPearl, 20.0);
        this.addProduct(Items.dragonEgg, 0.1);
    }

    @Override
    public double getFishOilVolume() {
        return 7.5;
    }

    @Override
    public int getFishMealSize() {
        return 13;
    }

    @Override
    public int getFoodStat() {
        return 3;
    }

    @Override
    public float getFoodSaturation() {
        return 0.65f;
    }

    @Override
    public int getFoodDuration() {
        return 64;
    }

    @Override
    public void onConsumed(World world, EntityPlayer player) {
        player.func_71024_bL().func_75122_a(12, 0.5f);
        world.func_72956_a((Entity)player, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 2000, 0));
    }

    @Override
    public boolean canWork(int time) {
        return !Environment.Time.isDay(time);
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.FLUX;
    }

    @Override
    public boolean isWorldCorrect(World world) {
        return world.field_73011_w.field_76574_g == 1;
    }

    @Override
    public int getCatchChance() {
        return 10;
    }

    @Override
    public double getCaughtAliveChance() {
        return 0.1;
    }
}

