/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;
import net.minecraft.item.ItemStack;

public class FishClown
extends FishSpecies {
    public FishClown(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{24, 27};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.SALINE, Environment.Salinity.BRACKISH};
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public int getLifeSpan() {
        return 7;
    }

    @Override
    public int getFertility() {
        return 2000;
    }

    @Override
    public int getBaseProductivity() {
        return 0;
    }

    @Override
    public int getFoodConsumption() {
        return 2;
    }

    @Override
    public int getWaterRequired() {
        return 200;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletWater, 3.0);
        this.addProduct(Items.dropletAqua, 2.0);
        this.addProduct(Items.dropletRegen, 2.5);
        this.addProduct(Items.dropletMagic, 1.0);
    }

    @Override
    public double getFishOilVolume() {
        return 1.8;
    }

    @Override
    public ItemStack getLiquifiedProduct() {
        return Items.orangeDye;
    }

    @Override
    public int getLiquifiedProductChance() {
        return 3;
    }

    @Override
    public boolean canWork(int time) {
        return !Environment.Time.isMidnight(time);
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.SUPER;
    }

    @Override
    public double getCatchChance(int height, int time) {
        return Environment.Height.isShallows(height) ? 20.0 : 0.0;
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return Environment.Time.isDawn(time) && height >= 48 && height <= 64 ? 5.0 : 0.0;
    }
}

