/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;
import net.minecraft.item.ItemStack;

public class FishButterfly
extends FishSpecies {
    public FishButterfly(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{23, 30};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.SALINE};
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public int getLifeSpan() {
        return 10;
    }

    @Override
    public int getFertility() {
        return 500;
    }

    @Override
    public int getWaterRequired() {
        return 30;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletWater, 10.0);
        this.addProduct(Items.feather, 4.0);
    }

    @Override
    public double getFishOilVolume() {
        return 0.12;
    }

    @Override
    public ItemStack getLiquifiedProduct() {
        return new ItemStack(Items.feather);
    }

    @Override
    public int getLiquifiedProductChance() {
        return 5;
    }

    @Override
    public int getFishMealSize() {
        return 1;
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.GOOD;
    }

    @Override
    public int getCatchChance() {
        return 20;
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return Environment.Time.isDawn(time) ? 5.0 : 0.0;
    }
}

