/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.fishery.Fishing;
import mariculture.core.Core;
import mariculture.core.blocks.base.TileMultiBlock;
import mariculture.core.blocks.base.TileMultiMachinePowered;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.gui.feature.FeatureNotifications;
import mariculture.core.lib.MachineSpeeds;
import mariculture.core.network.Packets;
import mariculture.core.util.IHasNotification;
import mariculture.core.util.Rand;
import mariculture.fishery.Fish;
import mariculture.fishery.FishHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public class TileIncubator
extends TileMultiMachinePowered
implements IHasNotification {
    private int cooldown = 0;
    private double mutation = 1.0;
    public int[] in = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12};
    public int[] out = new int[]{13, 14, 15, 16, 17, 18, 19, 20, 21};

    public TileIncubator() {
        this.max = MachineSpeeds.getIncubatorSpeed();
        this.inventory = new ItemStack[22];
        this.needsInit = true;
    }

    public void setMutationModifier(double d) {
        TileIncubator tile = (TileIncubator)this.getMaster();
        if (tile != null) {
            tile.cooldown = 25;
            tile.mutation = d;
        }
    }

    @Override
    public int getRFCapacity() {
        return 50000;
    }

    public int[] func_94128_d(int side) {
        return new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot > 3 && slot < 13 && (Fishing.fishHelper.isEgg(stack) || stack.field_77993_c == Item.field_77764_aP.field_77779_bT || stack.field_77993_c == Block.field_72084_bK.field_71990_ca);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot > 12;
    }

    @Override
    public boolean canWork() {
        return this.hasPower() && this.hasEgg() && this.rsAllowsWork() && this.outputHasRoom();
    }

    private boolean outputHasRoom() {
        if (this.setting.canEject(FeatureEject.EjectSetting.ITEM)) {
            return true;
        }
        int i$ = 0;
        int[] arr$ = this.out;
        int len$ = arr$.length;
        if (i$ < len$) {
            Integer i = arr$[i$];
            if (this.inventory[i] == null) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    @Override
    public void updateMasterMachine() {
        if (!this.field_70331_k.field_72995_K) {
            if (this.cooldown > 0) {
                --this.cooldown;
            } else {
                this.mutation = 1.0;
            }
            if (this.canWork) {
                this.energyStorage.extractEnergy(this.getRFUsage(), false);
                this.processed += this.speed;
                if (this.onTick(70)) {
                    this.processed -= this.heat;
                }
                if (this.processed >= this.max) {
                    this.processed = 0;
                    if (this.canWork()) {
                        int loop = MaricultureHandlers.upgrades.hasUpgrade("incubator", this) ? 1024 : this.heat + 1;
                        for (int o = 0; o < loop; ++o) {
                            this.hatchEgg();
                        }
                    }
                    this.canWork = this.canWork();
                }
            } else {
                this.processed = 0;
            }
            if (this.processed <= 0) {
                this.processed = 0;
            }
        }
    }

    @Override
    public void updateSlaveMachine() {
    }

    private boolean hasEgg() {
        int[] arr$ = this.in;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer i = arr$[i$];
            if (this.inventory[i] == null) continue;
            return true;
        }
        return false;
    }

    private boolean hasPower() {
        return this.energyStorage.extractEnergy(this.getRFUsage() * 2, true) >= this.getRFUsage() * 2;
    }

    public int getRFUsage() {
        return 35 + (this.speed - 1) * 40 + this.heat * 80;
    }

    public boolean hatchEgg() {
        Integer[] inArray = new Integer[this.in.length];
        int i = 0;
        for (int value : this.in) {
            inArray[i++] = value;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(Arrays.asList(inArray));
        Collections.shuffle(list);
        for (Integer j : list) {
            if (this.inventory[j] == null || !this.openEgg(j)) continue;
            return true;
        }
        return false;
    }

    private boolean openEgg(int slot) {
        if (this.inventory[slot] == null) {
            return false;
        }
        Random rand = new Random();
        if (Fishing.fishHelper.isEgg(this.inventory[slot])) {
            int[] fertility = this.inventory[slot].field_77990_d.func_74759_k(Fish.fertility.getEggString());
            int[] lifes = this.inventory[slot].field_77990_d.func_74759_k(Fish.lifespan.getEggString());
            if (this.inventory[slot].func_77978_p().func_74764_b("SpeciesList")) {
                ItemStack fish;
                int birthChance = 1 + MaricultureHandlers.upgrades.getData("purity", this);
                this.inventory[slot].func_77978_p().func_74768_a("currentFertility", this.inventory[slot].func_77978_p().func_74762_e("currentFertility") - 1);
                if (rand.nextInt(1000) < birthChance) {
                    fish = Fishing.fishHelper.makeBredFish(this.inventory[slot], rand, this.mutation);
                    if (fish != null) {
                        int dna = Fish.gender.getDNA(fish);
                        this.helper.insertStack(fish, this.out);
                        if (dna == FishHelper.MALE) {
                            this.inventory[slot].func_77978_p().func_74768_a("malesGenerated", this.inventory[slot].func_77978_p().func_74762_e("malesGenerated") + 1);
                        } else if (dna == FishHelper.FEMALE) {
                            this.inventory[slot].func_77978_p().func_74768_a("femalesGenerated", this.inventory[slot].func_77978_p().func_74762_e("femalesGenerated") + 1);
                        }
                    } else {
                        this.helper.insertStack(new ItemStack(Item.field_77754_aU, 2, 0), this.out);
                    }
                }
                if (this.inventory[slot].func_77978_p().func_74762_e("currentFertility") == 0) {
                    fish = Fishing.fishHelper.makeBredFish(this.inventory[slot], rand, this.mutation);
                    if (fish != null) {
                        if (this.inventory[slot].func_77978_p().func_74762_e("malesGenerated") <= 0) {
                            this.helper.insertStack(Fish.gender.addDNA(fish.func_77946_l(), FishHelper.MALE), this.out);
                        }
                        if ((fish = Fishing.fishHelper.makeBredFish(this.inventory[slot], rand, this.mutation)) != null && this.inventory[slot].func_77978_p().func_74762_e("femalesGenerated") <= 0) {
                            this.helper.insertStack(Fish.gender.addDNA(fish.func_77946_l(), FishHelper.FEMALE), this.out);
                        }
                    } else {
                        this.helper.insertStack(new ItemStack(Item.field_77754_aU), this.out);
                    }
                    this.func_70298_a(slot, 1);
                    return true;
                }
            }
        } else {
            if (this.inventory[slot].field_77993_c == Item.field_77764_aP.field_77779_bT) {
                if (Rand.nextInt(8)) {
                    this.helper.insertStack(new ItemStack(383, 1, 93), this.out);
                }
                this.func_70298_a(slot, 1);
                return true;
            }
            if (this.inventory[slot].field_77993_c == Block.field_72084_bK.field_71990_ca) {
                int chance;
                int n = chance = MaricultureHandlers.upgrades.hasUpgrade("ethereal", this) ? 48000 : 64000;
                if (Rand.nextInt(chance)) {
                    this.helper.insertStack(new ItemStack(Core.crafting, 1, 15), this.out);
                }
                if (Rand.nextInt(10)) {
                    this.func_70298_a(slot, 1);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isNotificationVisible(FeatureNotifications.NotificationType type) {
        switch (type) {
            case NO_EGG: {
                return !this.hasEgg();
            }
            case NO_RF: {
                return !this.hasPower();
            }
        }
        return false;
    }

    @Override
    public FeatureEject.EjectSetting getEjectType() {
        return FeatureEject.EjectSetting.ITEM;
    }

    @Override
    public Class getTEClass() {
        return TileIncubator.class;
    }

    @Override
    public void onBlockPlaced() {
        this.onBlockPlaced(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        Packets.updateTile(this, this.func_70319_e());
    }

    public void onBlockPlaced(int x, int y, int z) {
        ArrayList<TileMultiBlock.MultiPart> parts;
        TileMultiBlock.MultiPart mstr;
        if (this.isBase(x, y, z) && this.isTop(x, y + 1, z) && this.isTop(x, y + 2, z) && !this.isTop(x, y + 3, z)) {
            mstr = new TileMultiBlock.MultiPart(x, y, z);
            parts = new ArrayList<TileMultiBlock.MultiPart>();
            parts.add(this.setAsSlave(mstr, x, y + 1, z, ForgeDirection.DOWN));
            parts.add(this.setAsSlave(mstr, x, y + 2, z));
            this.setAsMaster(mstr, parts);
        }
        if (this.isBase(x, y - 1, z) && this.isTop(x, y, z) && this.isTop(x, y + 1, z) && !this.isTop(x, y + 2, z)) {
            mstr = new TileMultiBlock.MultiPart(x, y - 1, z);
            parts = new ArrayList();
            parts.add(this.setAsSlave(mstr, x, y, z, ForgeDirection.DOWN));
            parts.add(this.setAsSlave(mstr, x, y + 1, z));
            this.setAsMaster(mstr, parts);
        }
        if (this.isBase(x, y - 2, z) && this.isTop(x, y - 1, z) && this.isTop(x, y, z) && !this.isTop(x, y + 1, z)) {
            mstr = new TileMultiBlock.MultiPart(x, y - 2, z);
            parts = new ArrayList();
            parts.add(this.setAsSlave(mstr, x, y - 1, z, ForgeDirection.DOWN));
            parts.add(this.setAsSlave(mstr, x, y, z));
            this.setAsMaster(mstr, parts);
        }
    }

    public boolean isBase(int x, int y, int z) {
        return this.field_70331_k.func_72798_a(x, y, z) == this.func_70311_o().field_71990_ca && this.field_70331_k.func_72805_g(x, y, z) == 0;
    }

    public boolean isTop(int x, int y, int z) {
        return this.field_70331_k.func_72798_a(x, y, z) == this.func_70311_o().field_71990_ca && this.field_70331_k.func_72805_g(x, y, z) == 1;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.mutation = nbt.func_74769_h("MutationModifier");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74780_a("MutationModifier", this.mutation);
    }
}

