/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import mariculture.api.core.Environment;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.fishery.EnumRodQuality;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.ILootHandler;
import mariculture.api.fishery.Loot;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Extra;
import mariculture.core.util.Rand;
import mariculture.fishery.Fishery;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LootHandler
implements ILootHandler {
    private static final ArrayList<Loot> goodies = new ArrayList();
    private static final ArrayList<Loot> junk = new ArrayList();
    public static ArrayList<FishSpecies> catchables;

    @Override
    public void addLoot(Loot loot) {
        if (loot.type == Loot.Rarity.GOOD) {
            goodies.add(loot);
        } else {
            junk.add(loot);
        }
    }

    private boolean dimensionMatches(World world, int dimension) {
        int id = world.field_73011_w.field_76574_g;
        if (dimension == Short.MAX_VALUE) {
            return true;
        }
        if (dimension == 0) {
            return id == 0 || dimension > 1 || dimension < -1;
        }
        return dimension == id;
    }

    private boolean rodIsAccepted(boolean exact, RodQuality quality, RodQuality rod) {
        if (rod == null) {
            return true;
        }
        if (quality == null) {
            return false;
        }
        if (exact) {
            return quality == rod;
        }
        return rod.getRank() >= quality.getRank();
    }

    public ItemStack getOtherLoot(Random rand, RodQuality quality, World world) {
        for (int i = 0; i < 25; ++i) {
            ArrayList<Loot> list = rand.nextInt(100) <= quality.getRatio() ? goodies : junk;
            Collections.shuffle(list);
            for (Loot loot : list) {
                if (!this.dimensionMatches(world, loot.dimension) || !this.rodIsAccepted(loot.exact, loot.quality, quality) || !Rand.nextInt(loot.rarity)) continue;
                ItemStack ret = loot.loot.func_77946_l();
                if (ret.func_77956_u() && !ret.func_77948_v()) {
                    if (quality.getRank() > RodQuality.GOOD.getRank()) {
                        int enchant = quality.getEnchantability();
                        EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)ret, (int)(enchant *= ret.field_77993_c == Item.field_77760_aL.field_77779_bT ? 2 : 1));
                    }
                }
                if (ret.func_77984_f()) {
                    if (quality.getRank() < RodQuality.GOOD.getRank()) {
                        int dmg = rand.nextInt(ret.func_77958_k());
                        ret.func_77964_b(dmg);
                    }
                }
                return ret;
            }
        }
        return null;
    }

    public ItemStack getReturn(World world, ItemStack ret) {
        if (ret != null) {
            return ret;
        }
        if (world.field_73011_w.field_76575_d) {
            return new ItemStack(Item.field_77753_aV);
        }
        if (world.field_73011_w.field_76574_g == 1) {
            return new ItemStack(Item.field_77730_bn);
        }
        return new ItemStack(Item.field_77754_aU);
    }

    @Override
    public ItemStack getLoot(Random rand, RodQuality quality, World world, int x, int y, int z) {
        if (rand.nextInt(100) > Math.min(95, quality.getRatio() + 45)) {
            ItemStack ret = this.getOtherLoot(rand, quality, world);
            return this.getReturn(world, this.getOtherLoot(rand, quality, world));
        }
        ItemStack ret = this.getFishForLocation(rand, quality, world, x, y, z);
        return this.getReturn(world, this.getFishForLocation(rand, quality, world, x, y, z));
    }

    private ItemStack getFishForLocation(Random rand, RodQuality quality, World world, int x, int y, int z) {
        if (catchables == null) {
            catchables = new ArrayList();
            for (Map.Entry<Integer, FishSpecies> species : FishSpecies.species.entrySet()) {
                catchables.add(species.getValue());
            }
        }
        Environment.Salinity salt = MaricultureHandlers.environment.getSalinity(world, x, z);
        int temperature = MaricultureHandlers.environment.getTemperature(world, x, y, z);
        int time = Environment.Time.getTime(world);
        for (int i = 0; i < 25; ++i) {
            Collections.shuffle(catchables);
            for (FishSpecies fish : catchables) {
                double catchChance;
                double d = catchChance = Extra.IGNORE_BIOMES ? fish.getCatchChance(world, y, time) : fish.getCatchChance(world, salt, temperature, time, y);
                if (quality.getEnum() != null && fish.canCatch(rand, world, x, y, z, quality.getEnum())) {
                    if (Extra.IGNORE_BIOMES) {
                        return this.catchFish(rand, fish, quality, fish.getCaughtAliveChance(world, y, time) * 10.0);
                    }
                    return this.catchFish(rand, fish, quality, fish.getCaughtAliveChance(world, salt, temperature, time, y) * 10.0);
                }
                if (!(catchChance > 0.0) || quality.getRank() < fish.getRodNeeded().getRank() || !((double)rand.nextInt(1000) < catchChance)) continue;
                if (Extra.IGNORE_BIOMES) {
                    return this.catchFish(rand, fish, quality, fish.getCaughtAliveChance(world, y, time) * 15.0);
                }
                return this.catchFish(rand, fish, quality, fish.getCaughtAliveChance(world, salt, temperature, time, y) * 10.0);
            }
        }
        return null;
    }

    private ItemStack catchFish(Random rand, FishSpecies fish, RodQuality quality, double chance) {
        boolean catchAlive;
        boolean alive = false;
        if ((double)rand.nextInt(1000) < chance * Extra.ALIVE_MODIFIER + (double)quality.getRatio()) {
            alive = true;
        }
        if (!(catchAlive = quality.caughtAlive(fish.getSpecies())) && !alive) {
            return new ItemStack(Fishery.fishyFood, 1, fish.getID());
        }
        return Fishing.fishHelper.makePureFish(fish);
    }

    @Override
    @Deprecated
    public void addLoot(ItemStack stack, Object ... args) {
        if (args.length == 2) {
            if (args[0] instanceof EnumRodQuality) {
                junk.add(new Loot(stack, ((EnumRodQuality)((Object)args[0])).getQuality(), Loot.Rarity.JUNK, (Integer)args[1], Short.MAX_VALUE, false));
            } else {
                junk.add(new Loot(stack, (RodQuality)args[0], Loot.Rarity.JUNK, (Integer)args[1], Short.MAX_VALUE, false));
            }
        } else if (args.length == 3 && args[2] instanceof Integer) {
            if (args[0] instanceof EnumRodQuality) {
                junk.add(new Loot(stack, ((EnumRodQuality)((Object)args[0])).getQuality(), Loot.Rarity.JUNK, (Integer)args[1], (Integer)args[2], false));
            } else {
                junk.add(new Loot(stack, (RodQuality)args[0], Loot.Rarity.JUNK, (Integer)args[1], (Integer)args[2], false));
            }
        } else if (args.length == 3) {
            junk.add(new Loot(stack, (RodQuality)args[0], Loot.Rarity.JUNK, (Integer)args[1], Short.MAX_VALUE, (Boolean)args[2]));
        } else if (args.length == 4) {
            junk.add(new Loot(stack, (RodQuality)args[0], Loot.Rarity.JUNK, (Integer)args[1], (Integer)args[2], (Boolean)args[3]));
        }
    }

    @Override
    public ItemStack getLoot(Random rand, EnumRodQuality quality, World world, int x, int y, int z) {
        return this.getLoot(rand, quality.getQuality(), world, x, y, z);
    }
}

