/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery;

import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import mariculture.Mariculture;
import mariculture.api.core.FuelInfo;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.MaricultureTab;
import mariculture.api.core.RecipeCasting;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.RecipeSifter;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.Core;
import mariculture.core.helpers.RecipeHelper;
import mariculture.core.helpers.RegistryHelper;
import mariculture.core.items.ItemBattery;
import mariculture.core.lib.BlockIds;
import mariculture.core.lib.Extra;
import mariculture.core.lib.ItemIds;
import mariculture.core.lib.Items;
import mariculture.core.lib.Modules;
import mariculture.core.util.FluidCustom;
import mariculture.core.util.FluidDictionary;
import mariculture.fishery.BaitHandler;
import mariculture.fishery.EntityBass;
import mariculture.fishery.EntityFishing;
import mariculture.fishery.Fish;
import mariculture.fishery.FishFoodHandler;
import mariculture.fishery.FishHelper;
import mariculture.fishery.FishMutationHandler;
import mariculture.fishery.FisheryEventHandler;
import mariculture.fishery.FishingLoot;
import mariculture.fishery.LootHandler;
import mariculture.fishery.RodQualityHandler;
import mariculture.fishery.RodRightClickHandler;
import mariculture.fishery.ShapelessFishRecipe;
import mariculture.fishery.SifterHandler;
import mariculture.fishery.blocks.BlockItemNeonLamp;
import mariculture.fishery.blocks.BlockItemNet;
import mariculture.fishery.blocks.BlockNeonLamp;
import mariculture.fishery.blocks.BlockSift;
import mariculture.fishery.blocks.TileAutofisher;
import mariculture.fishery.blocks.TileFeeder;
import mariculture.fishery.blocks.TileFishTank;
import mariculture.fishery.blocks.TileIncubator;
import mariculture.fishery.blocks.TileSift;
import mariculture.fishery.items.ItemBait;
import mariculture.fishery.items.ItemFishy;
import mariculture.fishery.items.ItemFishyFood;
import mariculture.fishery.items.ItemFluxRod;
import mariculture.fishery.items.ItemRod;
import mariculture.fishery.items.ItemScanner;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class Fishery
extends Modules.RegistrationModule {
    @Deprecated
    public static FishSpecies nether;
    @Deprecated
    public static FishSpecies glow;
    @Deprecated
    public static FishSpecies blaze;
    @Deprecated
    public static FishSpecies night;
    @Deprecated
    public static FishSpecies ender;
    @Deprecated
    public static FishSpecies dragon;
    @Deprecated
    public static FishSpecies minnow;
    @Deprecated
    public static FishSpecies salmon;
    @Deprecated
    public static FishSpecies bass;
    @Deprecated
    public static FishSpecies tetra;
    @Deprecated
    public static FishSpecies catfish;
    @Deprecated
    public static FishSpecies piranha;
    @Deprecated
    public static FishSpecies cod;
    @Deprecated
    public static FishSpecies perch;
    @Deprecated
    public static FishSpecies tuna;
    @Deprecated
    public static FishSpecies stingRay;
    @Deprecated
    public static FishSpecies mantaRay;
    @Deprecated
    public static FishSpecies electricRay;
    @Deprecated
    public static FishSpecies damsel;
    @Deprecated
    public static FishSpecies angel;
    @Deprecated
    public static FishSpecies puffer;
    @Deprecated
    public static FishSpecies squid;
    @Deprecated
    public static FishSpecies jelly;
    @Deprecated
    public static FishSpecies manOWar;
    @Deprecated
    public static FishSpecies gold;
    @Deprecated
    public static FishSpecies siamese;
    @Deprecated
    public static FishSpecies koi;
    @Deprecated
    public static FishSpecies butterfly;
    @Deprecated
    public static FishSpecies tang;
    @Deprecated
    public static FishSpecies clown;
    public static Block siftBlock;
    public static Block lampsOff;
    public static Block lampsOn;
    public static Item bait;
    public static Item rodWood;
    public static Item rodTitanium;
    public static Item rodReed;
    public static Item rodFlux;
    public static Item fishy;
    public static Item fishyFood;
    public static Item net;
    public static Item scanner;
    public static Fluid fishFood;
    public static Fluid fishOil;
    public static Fluid milk;
    public static Fluid custard;
    public static Fluid dirt;
    @Deprecated
    public static boolean isActive;

    @Override
    public void registerHandlers() {
        Fishing.bait = new BaitHandler();
        Fishing.quality = new RodQualityHandler();
        Fishing.mutation = new FishMutationHandler();
        Fishing.fishHelper = new FishHelper();
        Fishing.loot = new LootHandler();
        Fishing.rodHandler = new RodRightClickHandler();
        Fishing.food = new FishFoodHandler();
        Fishing.sifter = new SifterHandler();
        MinecraftForge.EVENT_BUS.register((Object)new FisheryEventHandler());
    }

    @Override
    public void registerBlocks() {
        siftBlock = new BlockSift(BlockIds.sift).func_71884_a(Block.field_71967_e).func_71848_c(1.0f).func_71864_b("siftBlock");
        lampsOff = new BlockNeonLamp(BlockIds.lampsOff, true).func_71864_b("lampsOff").func_71868_h(0);
        lampsOn = new BlockNeonLamp(BlockIds.lampsOn, false).func_71864_b("lampsOn").func_71868_h(0);
        Item.field_77698_e[BlockIds.lampsOn] = new BlockItemNeonLamp(BlockIds.lampsOn - 256, lampsOn).func_77655_b("lampsOn");
        Item.field_77698_e[BlockIds.lampsOff] = new BlockItemNeonLamp(BlockIds.lampsOff - 256, lampsOff).func_77655_b("lampsOff");
        GameRegistry.registerBlock((Block)siftBlock, (String)"Mariculture_siftBlock");
        GameRegistry.registerTileEntity(TileAutofisher.class, (String)"tileEntityAutofisher");
        GameRegistry.registerTileEntity(TileSift.class, (String)"tileEntitySift");
        GameRegistry.registerTileEntity(TileIncubator.class, (String)"tileIncubator");
        GameRegistry.registerTileEntity(TileFeeder.class, (String)"tileFeeder");
        GameRegistry.registerTileEntity(TileFishTank.class, (String)"tileFishTank");
        MinecraftForge.setBlockHarvestLevel((Block)Core.machines, (int)0, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)Core.machines, (int)1, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)Core.rendered, (int)0, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)Core.wood, (int)2, (String)"axe", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)Core.wood, (int)1, (String)"axe", (int)0);
        RegistryHelper.register(new Object[]{siftBlock, lampsOff, lampsOn});
        FluidDictionary.fish_food = Core.addFluid("food.fish", fishFood, 512, 16);
        FluidDictionary.fish_oil = Core.addFluid("oil.fish", fishOil, 2000, 1);
        FluidDictionary.milk = Core.addFluid("milk", milk, 2000, 24);
        FluidDictionary.custard = Core.addFluid("custard", custard, 2000, 25);
        dirt = new FluidCustom("molten.dirt", "Molten Dirt", Block.field_71979_v.field_71990_ca, 0).setUnlocalizedName("dirt");
        FluidRegistry.registerFluid((Fluid)dirt);
        Core.registerVanillaBottle(FluidDictionary.fish_food, 256, 28);
        Core.registerVanillaBottle(FluidDictionary.fish_oil, 1000, 29);
        Core.registerVanillaBottle(FluidDictionary.milk, 1000, 30);
        Core.registerVanillaBottle(FluidDictionary.custard, 1000, 31);
        FluidContainerRegistry.registerFluidContainer((FluidStack)FluidRegistry.getFluidStack((String)FluidDictionary.custard, (int)250), (ItemStack)new ItemStack(Core.food, 1, 3), (ItemStack)new ItemStack(Item.field_77670_E));
        FluidContainerRegistry.registerFluidContainer((FluidStack)FluidRegistry.getFluidStack((String)FluidDictionary.milk, (int)1000), (ItemStack)new ItemStack(Item.field_77771_aG), (ItemStack)new ItemStack(Item.field_77788_aw));
    }

    @Override
    public void registerItems() {
        bait = new ItemBait(ItemIds.bait).func_77655_b("bait");
        rodReed = new ItemRod(ItemIds.rodReed, RodQuality.OLD).func_77655_b("rodReed");
        rodWood = new ItemRod(ItemIds.rodWood, RodQuality.GOOD).func_77655_b("rodWood");
        rodTitanium = new ItemRod(ItemIds.rodTitanium, RodQuality.SUPER).func_77655_b("rodTitanium");
        rodFlux = new ItemFluxRod(ItemIds.rodFlux, RodQuality.FLUX).func_77655_b("rodFlux");
        fishy = new ItemFishy(ItemIds.fishy).func_77655_b("fishy").func_77637_a((CreativeTabs)MaricultureTab.tabFish);
        fishyFood = new ItemFishyFood(ItemIds.fishyFood).func_77655_b("fishyFood");
        net = new BlockItemNet(ItemIds.net).func_77655_b("net");
        scanner = new ItemScanner(ItemIds.scanner).func_77655_b("scanner");
        RegistryHelper.register(new Object[]{bait, rodReed, rodWood, rodTitanium, fishy, fishyFood, net, rodFlux, scanner});
    }

    @Override
    public void registerOther() {
        this.registerEntities();
        this.registerFish();
        MaricultureTab.tabFish.icon = Fishing.fishHelper.makePureFish(Fish.cod);
    }

    private void registerEntities() {
        EntityRegistry.registerModEntity(EntityBass.class, (String)"BassBomb", (int)41, (Object)Mariculture.instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityFishing.class, (String)"NewFishing", (int)42, (Object)Mariculture.instance, (int)80, (int)3, (boolean)true);
    }

    private void registerFish() {
        Fish.init();
        nether = Fish.nether;
        glow = Fish.glow;
        blaze = Fish.blaze;
        night = Fish.night;
        ender = Fish.ender;
        dragon = Fish.dragon;
        minnow = Fish.minnow;
        salmon = Fish.salmon;
        bass = Fish.bass;
        tetra = Fish.tetra;
        catfish = Fish.catfish;
        piranha = Fish.piranha;
        cod = Fish.cod;
        perch = Fish.perch;
        tuna = Fish.tuna;
        stingRay = Fish.stingRay;
        mantaRay = Fish.mantaRay;
        electricRay = Fish.electricRay;
        damsel = Fish.damsel;
        angel = Fish.angel;
        puffer = Fish.puffer;
        squid = Fish.squid;
        jelly = Fish.jelly;
        manOWar = Fish.manOWar;
        gold = Fish.gold;
        siamese = Fish.siamese;
        koi = Fish.koi;
        butterfly = Fish.butterfly;
        tang = Fish.tang;
        clown = Fish.clown;
    }

    @Override
    public void registerRecipes() {
        this.addBait();
        this.addDropletRecipes();
        this.addFishRecipes();
        FishingLoot.add();
        RecipeHelper.addFishingRodRecipe(new ItemStack(rodReed), Item.field_77758_aJ);
        RecipeHelper.addFishingRodRecipe(new ItemStack(rodWood), new ItemStack(Core.crafting, 1, 3));
        RecipeHelper.addFishingRodRecipe(new ItemStack(rodTitanium), new ItemStack(Core.crafting, 1, 2));
        RecipeHelper.addShapedRecipe(ItemBattery.make(new ItemStack(rodFlux), 0), new Object[]{"  R", " RS", "B S", Character.valueOf('R'), rodTitanium, Character.valueOf('S'), Items.string, Character.valueOf('B'), Items.titaniumBattery});
        RecipeHelper.addShapedRecipe(new ItemStack(scanner), new Object[]{"WPE", "NFR", "JBO", Character.valueOf('N'), Items.dropletNether, Character.valueOf('P'), Items.pearls, Character.valueOf('W'), Items.dropletWater, Character.valueOf('R'), Items.dropletEarth, Character.valueOf('F'), Items.fish, Character.valueOf('O'), Items.dropletEnder, Character.valueOf('E'), Items.dropletFrozen, Character.valueOf('B'), Items.copperBattery, Character.valueOf('J'), Items.dropletPoison});
        if (!Extra.DISABLE_DIRT_CRAFTING) {
            MaricultureHandlers.casting.addRecipe(new RecipeCasting.RecipeBlockCasting(new FluidStack(dirt, 1000), new ItemStack(Block.field_71979_v)));
        }
        RecipeHelper.addMelting(new ItemStack(Items.dirt), 333, new FluidStack(dirt, 1000));
        RecipeHelper.addVatItemRecipe(new ItemStack(Block.field_71951_J), FluidDictionary.fish_oil, 30000, Items.polishedLog, 45);
        RecipeHelper.addVatItemRecipe(new ItemStack(Block.field_71988_x), FluidDictionary.fish_oil, 10000, Items.polishedPlank, 30);
        RecipeHelper.addVatItemRecipe(new ItemStack(Item.field_77669_D), FluidDictionary.fish_oil, 5000, new ItemStack(Core.crafting, 1, 3), 15);
        RecipeHelper.addShapelessRecipe(new ItemStack(Core.wood, 4, 1), new Object[]{Items.polishedLog});
        RecipeHelper.addShapedRecipe(new ItemStack(Core.crafting, 4, 3), new Object[]{"S", "S", Character.valueOf('S'), Items.polishedPlank});
        RecipeHelper.addVatItemRecipe(new ItemStack(Core.crafting, 1, 20), FluidDictionary.fish_oil, 6500, new ItemStack(Core.crafting, 1, 2), 30);
        RecipeHelper.addShapedRecipe(new ItemStack(net, 4, 0), new Object[]{"SWS", "WWW", "SWS", Character.valueOf('S'), "stickWood", Character.valueOf('W'), Items.string});
        RecipeHelper.addShapedRecipe(new ItemStack(siftBlock), new Object[]{"PNP", "S S", Character.valueOf('S'), "stickWood", Character.valueOf('P'), "plankWood", Character.valueOf('N'), net});
        RecipeHelper.addShapedRecipe(Items.autofisher, new Object[]{" F ", "RPR", "WBW", Character.valueOf('W'), "logWood", Character.valueOf('R'), rodWood, Character.valueOf('F'), Items.fish, Character.valueOf('B'), Items.baseWood, Character.valueOf('P'), "plankWood"});
        RecipeHelper.addShapedRecipe(Items.fishFeeder, new Object[]{"WFW", "WCW", "WFW", Character.valueOf('F'), Items.fish, Character.valueOf('W'), Items.wicker, Character.valueOf('C'), Items.chest});
        RecipeHelper.addShapedRecipe(Items.incubatorTop, new Object[]{"DFD", "CHC", Character.valueOf('F'), Items.fish, Character.valueOf('D'), "dyeBrown", Character.valueOf('C'), new ItemStack(Block.field_111039_cA, 1, 0), Character.valueOf('H'), Items.heating});
        RecipeHelper.addShapedRecipe(Items.incubatorBase, new Object[]{"DBD", "CHC", Character.valueOf('C'), new ItemStack(Block.field_111039_cA, 1, 3), Character.valueOf('B'), Items.copperBattery, Character.valueOf('D'), "dyeLightBlue", Character.valueOf('H'), Items.heating});
        RecipeHelper.addShapedRecipe(Items.fishTank, new Object[]{"AGA", "GFG", "AGA", Character.valueOf('A'), "ingotAluminum", Character.valueOf('G'), "glass", Character.valueOf('F'), Items.fish});
        RecipeHelper.addVatItemRecipeResultFluid(new ItemStack(Item.field_77747_aY, 2, 0), FluidRegistry.getFluidStack((String)FluidDictionary.milk, (int)1000), FluidRegistry.getFluidStack((String)FluidDictionary.custard, (int)1000), 15);
        RecipeHelper.addVatItemRecipe(Items.dropletFlux, "water", 1000, Items.dustMagnesium, 25);
        RecipeHelper.addShapelessRecipe(Items.thermometer, new Object[]{Item.field_77750_aQ, Items.fish});
    }

    private void addBait() {
        Fishing.bait.addBait(new ItemStack(bait, 1, 1), 10);
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 1), new ItemStack(Block.field_71979_v), 2, 3, 40));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 1), new ItemStack((Block)Block.field_71980_u), 1, 2, 50));
        Fishing.bait.addBait(new ItemStack(Item.field_77684_U), 30);
        Fishing.bait.addBait(new ItemStack(bait, 1, 3), 40);
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 3), new ItemStack((Block)Block.field_71980_u), 1, 2, 35));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 3), new ItemStack(Block.field_71987_y), 2, 3, 35));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 3), new ItemStack((Block)Block.field_71952_K), 1, 2, 15));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 3), new ItemStack((Block)Block.field_71962_X, 0, 1), 4, 5, 45));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 3), new ItemStack((Block)Block.field_71962_X, 0, 2), 2, 3, 40));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 3), new ItemStack((Block)Block.field_71962_X, 0, 0), 1, 2, 10));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 3), new ItemStack((Block)Block.field_72097_ad), 2, 5, 20));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 3), new ItemStack((Block)Block.field_72107_ae), 3, 4, 25));
        Fishing.bait.addBait(new ItemStack(bait, 1, 2), 55);
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 2), new ItemStack(Item.field_77737_bm), 1, 2, 60));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 2), new ItemStack(Item.field_77741_bi), 14, 22, 20));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 2), new ItemStack(Item.field_77735_bk), 6, 14, 30));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 2), new ItemStack(Item.field_77784_aq), 10, 18, 25));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 2), Items.zombie, 8, 15, 80));
        Fishing.bait.addBait(new ItemStack(bait, 1, 4), 70);
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 4), new ItemStack((Block)Block.field_72097_ad), 2, 3, 25));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 4), new ItemStack((Block)Block.field_72107_ae), 1, 2, 30));
        Fishing.bait.addBait(new ItemStack(bait, 1, 0), 75);
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 0), new ItemStack(Item.field_77706_j), 1, 3, 15));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 0), new ItemStack(Block.field_71979_v), 2, 3, 10));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 0), new ItemStack((Block)Block.field_71980_u), 3, 5, 20));
        Fishing.bait.addBait(new ItemStack(fishyFood, 1, Fish.minnow.getID()), 100);
        Fishing.quality.addBaitForQuality(new ItemStack(bait, 1, 1), Arrays.asList(RodQuality.OLD, RodQuality.FLUX));
        Fishing.quality.addBaitForQuality(new ItemStack(Item.field_77684_U), Arrays.asList(RodQuality.OLD, RodQuality.FLUX));
        Fishing.quality.addBaitForQuality(new ItemStack(bait, 1, 3), Arrays.asList(RodQuality.OLD, RodQuality.GOOD, RodQuality.FLUX));
        Fishing.quality.addBaitForQuality(new ItemStack(bait, 1, 2), Arrays.asList(RodQuality.GOOD, RodQuality.FLUX));
        Fishing.quality.addBaitForQuality(new ItemStack(bait, 1, 0), Arrays.asList(RodQuality.GOOD, RodQuality.SUPER, RodQuality.FLUX));
        Fishing.quality.addBaitForQuality(new ItemStack(bait, 1, 4), Arrays.asList(RodQuality.SUPER, RodQuality.FLUX));
        Fishing.quality.addBaitForQuality(new ItemStack(fishyFood, 1, Fish.minnow.getID()), Arrays.asList(RodQuality.SUPER, RodQuality.FLUX));
    }

    private void addDropletRecipes() {
        if (!Extra.DISABLE_GRASS) {
            RecipeHelper.addShapedRecipe(new ItemStack(Items.grass), new Object[]{"HHH", "EEE", "EEE", Character.valueOf('H'), Items.dropletPlant, Character.valueOf('E'), Items.dropletEarth});
        }
        RecipeHelper.add2x2Recipe(new ItemStack(Items.snowball), Items.dropletFrozen);
        RecipeHelper.add3x3Recipe(new ItemStack(Items.ice), Items.dropletFrozen);
        RecipeHelper.addMelting(Items.dropletEarth, 333, new FluidStack(dirt, 100));
        RecipeHelper.addMelting(Items.dropletWater, 1, FluidRegistry.getFluidStack((String)"water", (int)1000));
        RecipeHelper.addMelting(Items.dropletAqua, 1, FluidRegistry.getFluidStack((String)FluidDictionary.hp_water, (int)250));
        RecipeHelper.addMelting(Items.dropletNether, 1000, FluidRegistry.getFluidStack((String)"lava", (int)100));
        RecipeHelper.addShapedRecipe(new ItemStack(Items.enderPearl), new Object[]{"DDD", "DDD", "DDD", Character.valueOf('D'), Items.dropletEnder});
        RecipeHelper.addShapedRecipe(new ItemStack(Block.field_72091_am), new Object[]{"DS ", "SD ", Character.valueOf('D'), Items.dropletDestroy, Character.valueOf('S'), Items.sand});
        if (FluidRegistry.getFluid((String)"life essence") != null) {
            RecipeHelper.addMelting(Items.dropletRegen, 100, FluidRegistry.getFluidStack((String)"life essence", (int)250));
        }
    }

    @Override
    public void postInit() {
        super.postInit();
        Fish.addRecipes();
    }

    private void addFishRecipes() {
        ItemStack cod = new ItemStack(fishyFood, 1, Fish.cod.getID());
        ItemStack dragon = new ItemStack(fishyFood, 1, Fish.dragon.getID());
        ItemStack squid = new ItemStack(fishyFood, 1, Fish.squid.getID());
        ItemStack tetra = new ItemStack(fishyFood, 1, Fish.tetra.getID());
        Fishing.food.addFishFood(new ItemStack(Fishery.bait.field_77779_bT, 1, 1), 1);
        Fishing.food.addFishFood(new ItemStack(Fishery.bait.field_77779_bT, 1, 2), 2);
        Fishing.food.addFishFood(new ItemStack(Fishery.bait.field_77779_bT, 1, 3), 2);
        Fishing.food.addFishFood(new ItemStack(Item.field_77684_U), 8);
        Fishing.food.addFishFood(new ItemStack(Fishery.bait.field_77779_bT, 1, 0), 3);
        Fishing.food.addFishFood(new ItemStack(Fishery.bait.field_77779_bT, 1, 4), 3);
        Fishing.food.addFishFood(new ItemStack(Core.materials.field_77779_bT, 1, 14), 12);
        RecipeHelper.addShapelessRecipe(Items.calamari, new Object[]{squid, Items.bowl});
        RecipeHelper.addSmelting(Fishery.fishyFood.field_77779_bT, Fish.salmon.getID(), new ItemStack(Core.food, 1, 2), 0.1f);
        RecipeHelper.addSmelting(Fishery.fishyFood.field_77779_bT, Fish.minecraft.getID(), new ItemStack(Item.field_77753_aV, 2, 0), 0.25f);
        RecipeHelper.addShapedRecipe(new ItemStack(Core.food, 16, 0), new Object[]{" B ", "BFB", " B ", Character.valueOf('F'), cod, Character.valueOf('B'), Items.bread});
        RecipeHelper.addShapelessRecipe(Items.fishNCustard, new Object[]{Items.custard, Items.fishFinger, Items.fishFinger, Items.fishFinger});
        for (int i = 0; i < 12; ++i) {
            RecipeHelper.addShapedRecipe(new ItemStack(lampsOn, 4, i), new Object[]{" D ", "PGP", " F ", Character.valueOf('P'), Items.pearls, Character.valueOf('G'), Items.transparent, Character.valueOf('F'), Items.dropletFlux, Character.valueOf('D'), Items.glowstone});
        }
        RecipeHelper.addShapedRecipe(Items.eternalMale, new Object[]{"WEW", "FRF", "DWD", Character.valueOf('W'), Items.blueWool, Character.valueOf('E'), Items.emeraldBlock, Character.valueOf('F'), dragon, Character.valueOf('R'), Items.dragonEgg, Character.valueOf('D'), Items.diamond});
        RecipeHelper.addShapedRecipe(Items.eternalFemale, new Object[]{"WEW", "FRF", "DWD", Character.valueOf('W'), Items.pinkWool, Character.valueOf('E'), Items.emeraldBlock, Character.valueOf('F'), dragon, Character.valueOf('R'), Items.dragonEgg, Character.valueOf('D'), Items.diamond});
        MaricultureHandlers.smelter.addFuel(new ItemStack(fishyFood, 1, Fish.nether.getID()), new FuelInfo(2000, 16, 2400));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessFishRecipe(new ItemStack(Core.food, 1, 6), new ItemStack(fishy)));
        RecipeHelper.addMelting(new ItemStack(Items.rawFish), 180, FluidRegistry.getFluidStack((String)FluidDictionary.fish_oil, (int)100));
        RecipeHelper.addShapelessRecipe(Items.fishMeal, new Object[]{Items.rawFish});
    }

    static {
        isActive = Modules.isActive(Modules.worldplus);
    }
}

