/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.ItemBaseRod;
import mariculture.api.fishery.RodQuality;
import mariculture.core.helpers.EnchantHelper;
import mariculture.magic.Magic;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityFishing
extends EntityFishHook {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private int inTile;
    private boolean inGround;
    public int field_70206_a;
    private int ticksInGround;
    private int ticksInAir;
    private int ticksCatchable;
    public Entity field_70205_c;
    private int fishPosRotationIncrements;
    private double fishX;
    private double fishY;
    private double fishZ;
    private double fishYaw;
    private double fishPitch;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    private short CATCH_CHANCE = (short)500;
    private short enchantLevel = 0;
    private float damage = 0.0f;

    public EntityFishing(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
        this.field_70158_ak = true;
    }

    @SideOnly(value=Side.CLIENT)
    public EntityFishing(World world, double x, double y, double z, EntityPlayer player) {
        this(world);
        this.func_70107_b(x, y, z);
        this.field_70158_ak = true;
        this.field_70204_b = player;
        player.field_71104_cf = this;
    }

    public EntityFishing(World world, EntityPlayer player, int baitQuality) {
        super(world);
        this.field_70158_ak = true;
        this.field_70204_b = player;
        this.field_70204_b.field_71104_cf = this;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70012_b(player.field_70165_t, player.field_70163_u + 1.62 - (double)player.field_70129_M, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        float f = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.func_70199_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.5f, 1.0f);
        this.CATCH_CHANCE = (short)baitQuality;
        this.enchantLevel = (short)(player != null ? EnchantHelper.getLevel(Magic.luck, player.func_71045_bC()) * 10 : 0);
        this.damage = this.getDamage(player);
    }

    private float getDamage(EntityPlayer player) {
        ItemStack held = player.func_71045_bC();
        if (held != null && held.func_77973_b() instanceof ItemBaseRod) {
            return ((ItemBaseRod)held.func_77973_b()).getDamage();
        }
        return 0.0f;
    }

    public void func_70071_h_() {
        if (this.fishPosRotationIncrements > 0) {
            double x = this.field_70165_t + (this.fishX - this.field_70165_t) / (double)this.fishPosRotationIncrements;
            double y = this.field_70163_u + (this.fishY - this.field_70163_u) / (double)this.fishPosRotationIncrements;
            double z = this.field_70161_v + (this.fishZ - this.field_70161_v) / (double)this.fishPosRotationIncrements;
            double var7 = MathHelper.func_76138_g((double)(this.fishYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + var7 / (double)this.fishPosRotationIncrements);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.fishPitch - (double)this.field_70125_A) / (double)this.fishPosRotationIncrements);
            --this.fishPosRotationIncrements;
            this.func_70107_b(x, y, z);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        } else {
            double d5;
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70204_b == null || this.field_70204_b.func_71045_bC() == null) {
                    this.func_70106_y();
                    return;
                }
                ItemStack var1 = this.field_70204_b.func_71045_bC();
                if (this.field_70204_b.field_70128_L || !this.field_70204_b.func_70089_S() || var1 == null || !(var1.func_77973_b() instanceof ItemBaseRod) || this.func_70068_e((Entity)this.field_70204_b) > 1024.0) {
                    this.func_70106_y();
                    this.field_70204_b.field_71104_cf = null;
                    return;
                }
                if (this.field_70205_c != null) {
                    if (!this.field_70205_c.field_70128_L) {
                        this.field_70165_t = this.field_70205_c.field_70165_t;
                        this.field_70163_u = this.field_70205_c.field_70121_D.field_72338_b + (double)this.field_70205_c.field_70131_O * 0.8;
                        this.field_70161_v = this.field_70205_c.field_70161_v;
                        return;
                    }
                    this.field_70205_c = null;
                }
            }
            if (this.field_70206_a > 0) {
                --this.field_70206_a;
            }
            if (this.inGround) {
                int var19 = this.field_70170_p.func_72798_a(this.xTile, this.yTile, this.zTile);
                if (var19 == this.inTile) {
                    ++this.ticksInGround;
                    if (this.ticksInGround == 1200) {
                        this.func_70106_y();
                    }
                    return;
                }
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            } else {
                ++this.ticksInAir;
            }
            Vec3 vec3 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3 vec31 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            MovingObjectPosition movingobjectposition = this.field_70170_p.func_72933_a(vec3, vec31);
            vec3 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec31 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (movingobjectposition != null) {
                vec31 = this.field_70170_p.func_82732_R().func_72345_a(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d4 = 0.0;
            for (int j = 0; j < list.size(); ++j) {
                float f;
                AxisAlignedBB axisalignedbb;
                MovingObjectPosition movingobjectposition1;
                Entity entity1 = (Entity)list.get(j);
                if (!entity1.func_70067_L() || entity1 == this.field_70204_b && this.ticksInAir < 5 || (movingobjectposition1 = (axisalignedbb = entity1.field_70121_D.func_72314_b((double)(f = 0.3f), (double)f, (double)f)).func_72327_a(vec3, vec31)) == null || !((d5 = vec3.func_72438_d(movingobjectposition1.field_72307_f)) < d4) && d4 != 0.0) continue;
                entity = entity1;
                d4 = d5;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity);
            }
            if (movingobjectposition != null) {
                if (movingobjectposition.field_72308_g != null) {
                    if (movingobjectposition.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.field_70204_b), this.damage)) {
                        this.field_70205_c = movingobjectposition.field_72308_g;
                    }
                } else {
                    this.inGround = true;
                }
            }
            if (!this.inGround) {
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                float var24 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
                this.field_70125_A = (float)(Math.atan2(this.field_70181_x, var24) * 180.0 / Math.PI);
                while (this.field_70125_A - this.field_70127_C < -180.0f) {
                    this.field_70127_C -= 360.0f;
                }
                while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                    this.field_70127_C += 360.0f;
                }
                while (this.field_70177_z - this.field_70126_B < -180.0f) {
                    this.field_70126_B -= 360.0f;
                }
                while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                    this.field_70126_B += 360.0f;
                }
                this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
                this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
                float f2 = 0.92f;
                if (this.field_70122_E || this.field_70123_F) {
                    f2 = 0.5f;
                }
                int b0 = 5;
                double d6 = 0.0;
                for (int var29 = 0; var29 < b0; ++var29) {
                    double d7 = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)(var29 + 0) / (double)b0 - 0.125 + 0.125;
                    double d8 = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)(var29 + 1) / (double)b0 - 0.125 + 0.125;
                    AxisAlignedBB axisalignedbb1 = AxisAlignedBB.func_72332_a().func_72299_a(this.field_70121_D.field_72340_a, d7, this.field_70121_D.field_72339_c, this.field_70121_D.field_72336_d, d8, this.field_70121_D.field_72334_f);
                    if (!this.field_70170_p.func_72830_b(axisalignedbb1, Material.field_76244_g) && !this.field_70170_p.func_72830_b(axisalignedbb1, Material.field_76256_h)) continue;
                    d6 += 1.0 / (double)b0;
                }
                if (d6 > 0.0) {
                    if (this.ticksCatchable > 0) {
                        --this.ticksCatchable;
                    } else {
                        short catchChance = (short)(this.CATCH_CHANCE + this.enchantLevel);
                        if (this.field_70146_Z.nextInt(2000) < catchChance) {
                            float f5;
                            this.ticksCatchable = this.field_70146_Z.nextInt(60) + 20;
                            this.field_70181_x -= (double)0.2f;
                            this.field_70170_p.func_72956_a((Entity)this.field_70204_b, "random.splash", 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                            float var30 = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
                            int l = 0;
                            while ((float)l < 1.0f + this.field_70130_N * 20.0f) {
                                f5 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                                float f4 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                                this.field_70170_p.func_72869_a("bubble", this.field_70165_t + (double)f5, (double)(var30 + 1.0f), this.field_70161_v + (double)f4, this.field_70159_w, this.field_70181_x - (double)(this.field_70146_Z.nextFloat() * 0.2f), this.field_70179_y);
                                ++l;
                            }
                            l = 0;
                            while ((float)l < 1.0f + this.field_70130_N * 20.0f) {
                                f5 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                                float f4 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                                this.field_70170_p.func_72869_a("splash", this.field_70165_t + (double)f5, (double)(var30 + 1.0f), this.field_70161_v + (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                                ++l;
                            }
                        }
                    }
                }
                if (this.ticksCatchable > 0) {
                    this.field_70181_x -= (double)(this.field_70146_Z.nextFloat() * this.field_70146_Z.nextFloat() * this.field_70146_Z.nextFloat()) * 0.2;
                }
                d5 = d6 * 2.0 - 1.0;
                this.field_70181_x += (double)0.04f * d5;
                if (d6 > 0.0) {
                    f2 = (float)((double)f2 * 0.9);
                    this.field_70181_x *= 0.8;
                }
                this.field_70159_w *= (double)f2;
                this.field_70181_x *= (double)f2;
                this.field_70179_y *= (double)f2;
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74777_a("xTile", (short)this.xTile);
        tagCompound.func_74777_a("yTile", (short)this.yTile);
        tagCompound.func_74777_a("zTile", (short)this.zTile);
        tagCompound.func_74777_a("catchChance", this.CATCH_CHANCE);
        tagCompound.func_74774_a("inTile", (byte)this.inTile);
        tagCompound.func_74774_a("shake", (byte)this.field_70206_a);
        tagCompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        this.xTile = tagCompound.func_74765_d("xTile");
        this.yTile = tagCompound.func_74765_d("yTile");
        this.zTile = tagCompound.func_74765_d("zTile");
        this.CATCH_CHANCE = tagCompound.func_74765_d("catchChance");
        this.inTile = tagCompound.func_74771_c("inTile") & 0xFF;
        this.field_70206_a = tagCompound.func_74771_c("shake") & 0xFF;
        this.inGround = tagCompound.func_74771_c("inGround") == 1;
    }

    public int func_70198_d() {
        if (this.field_70170_p.field_72995_K) {
            return 0;
        }
        int b0 = 0;
        if (this.field_70205_c != null) {
            double d0 = this.field_70204_b.field_70165_t - this.field_70165_t;
            double d1 = this.field_70204_b.field_70163_u - this.field_70163_u;
            double d2 = this.field_70204_b.field_70161_v - this.field_70161_v;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
            double d4 = 0.1;
            this.field_70205_c.field_70159_w += d0 * d4;
            this.field_70205_c.field_70181_x += d1 * d4 + (double)MathHelper.func_76133_a((double)d3) * 0.08;
            this.field_70205_c.field_70179_y += d2 * d4;
            b0 = 3;
        } else if (this.ticksCatchable > 0 && this.field_70204_b.func_71045_bC().func_77973_b() instanceof ItemBaseRod) {
            RodQuality quality = ((ItemBaseRod)this.field_70204_b.func_71045_bC().func_77973_b()).getQuality();
            ItemStack loot = Fishing.loot.getLoot(new Random(), quality, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            if (loot != null) {
                EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, loot);
                entityItem.field_70174_ab = 200;
                double var3 = this.field_70204_b.field_70165_t - this.field_70165_t;
                double var5 = this.field_70204_b.field_70163_u - this.field_70163_u;
                double var7 = this.field_70204_b.field_70161_v - this.field_70161_v;
                double var9 = MathHelper.func_76133_a((double)(var3 * var3 + var5 * var5 + var7 * var7));
                double var11 = 0.1;
                entityItem.field_70159_w = var3 * var11;
                entityItem.field_70181_x = var5 * var11 + (double)MathHelper.func_76133_a((double)var9) * 0.08;
                entityItem.field_70179_y = var7 * var11;
                this.field_70170_p.func_72838_d((Entity)entityItem);
                this.field_70204_b.func_71064_a(StatList.field_75933_B, 1);
                this.field_70204_b.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70204_b.field_70170_p, this.field_70204_b.field_70165_t, this.field_70204_b.field_70163_u + 0.5, this.field_70204_b.field_70161_v + 0.5, this.field_70146_Z.nextInt(6) + 1));
                b0 = 1;
            } else {
                this.ticksCatchable = this.field_70146_Z.nextInt(120) + 40;
            }
        }
        if (this.inGround) {
            b0 = 2;
        }
        this.func_70106_y();
        this.field_70204_b.field_71104_cf = null;
        return b0;
    }
}

