/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.blocks;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import mariculture.api.core.IUpgradable;
import mariculture.api.core.MaricultureHandlers;
import mariculture.core.blocks.base.TileStorageTank;
import mariculture.core.gui.ContainerMariculture;
import mariculture.core.gui.feature.FeatureNotifications;
import mariculture.core.gui.feature.FeatureRedstone;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.helpers.cofh.BlockHelper;
import mariculture.core.lib.Extra;
import mariculture.core.network.Packet119TurbineAnimate;
import mariculture.core.network.Packets;
import mariculture.core.util.IMachine;
import mariculture.core.util.IPowered;
import mariculture.core.util.IRedstoneControlled;
import mariculture.core.util.Tank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileTurbineBase
extends TileStorageTank
implements IUpgradable,
IMachine,
IRedstoneControlled,
IEnergyHandler,
IPowered,
ISidedInventory {
    protected int machineTick = 0;
    protected int purity = 0;
    protected int heat = 0;
    protected int storage = 0;
    protected int speed = 0;
    protected int rf = 0;
    protected FeatureRedstone.RedstoneMode mode;
    public ForgeDirection direction = ForgeDirection.UP;
    public EnergyStage energyStage = EnergyStage.BLUE;
    public EnergyStorage energyStorage;
    protected boolean hasGUI = true;
    public boolean isAnimating;
    public boolean isTransferringPower;
    public boolean isCreatingPower;
    public double angle = 0.0;
    public double angle_external = 0.0;
    public static final int rotor = 6;

    public TileTurbineBase() {
        this.inventory = new ItemStack[7];
        this.tank = new Tank(this.getTankCapacity());
        this.mode = FeatureRedstone.RedstoneMode.LOW;
        this.energyStorage = new EnergyStorage(this.getRFCapacity());
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Override
    public ItemStack[] getUpgrades() {
        return new ItemStack[]{this.inventory[0], this.inventory[1], this.inventory[2]};
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public boolean onTick(int i) {
        return this.machineTick % i == 0;
    }

    @Override
    public void updateUpgrades() {
        this.purity = MaricultureHandlers.upgrades.getData("purity", this);
        this.heat = MaricultureHandlers.upgrades.getData("temp", this);
        this.storage = MaricultureHandlers.upgrades.getData("storage", this);
        this.speed = MaricultureHandlers.upgrades.getData("speed", this);
        this.rf = MaricultureHandlers.upgrades.getData("rf", this);
        this.tank.setCapacity(this.getTankCapacity());
        if (this.tank.getFluidAmount() > this.tank.getCapacity()) {
            this.tank.setFluidAmount(this.tank.getCapacity());
        }
        this.energyStorage.setCapacity(this.getRFCapacity());
        if (this.energyStorage.getEnergyStored() > this.energyStorage.getMaxEnergyStored()) {
            this.energyStorage.setEnergyStored(this.energyStorage.getMaxEnergyStored());
        }
    }

    public int getRFCapacity() {
        return 1000 + this.rf;
    }

    public int getTankCapacity() {
        int tankRate = 1000;
        return tankRate * 20 + this.storage * tankRate;
    }

    public abstract int getEnergyGenerated();

    public abstract int getEnergyTransferMax();

    public void doBattery() {
        int drain;
        int rf;
        if (this.inventory[5] != null && this.inventory[5].func_77973_b() instanceof IEnergyContainerItem && (rf = this.extractEnergy(ForgeDirection.UP, 10000, true)) > 0 && (drain = ((IEnergyContainerItem)this.inventory[5].func_77973_b()).receiveEnergy(this.inventory[5], rf, true)) > 0) {
            this.extractEnergy(ForgeDirection.UP, drain, false);
            ((IEnergyContainerItem)this.inventory[5].func_77973_b()).receiveEnergy(this.inventory[5], drain, false);
        }
    }

    public void func_70316_g() {
        super.func_70316_g();
        ++this.machineTick;
        if (!this.field_70331_k.field_72995_K && this.onTick(20)) {
            if (this.hasGUI) {
                FluidHelper.process(this, 3, 4);
                this.updateUpgrades();
                this.doBattery();
            }
            this.energyStage = this.isAnimating ? this.computeEnergyStage() : EnergyStage.BLUE;
        }
        this.updateTurbine();
    }

    public void updateTurbine() {
        if (!this.field_70331_k.field_72995_K) {
            if (this.canOperate()) {
                this.addPower();
            } else {
                this.isCreatingPower = false;
            }
            this.transferPower();
        }
        this.animate();
    }

    public abstract boolean canOperate();

    public abstract void addPower();

    public void transferPower() {
        TileEntity tile = BlockHelper.getAdjacentTileEntity(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.direction);
        if (tile instanceof IEnergyHandler && this.energyStorage.getEnergyStored() > 0) {
            if (((IEnergyHandler)tile).canInterface(this.direction.getOpposite())) {
                int extract = -((IEnergyHandler)tile).receiveEnergy(this.direction.getOpposite(), Math.min(this.getEnergyTransferMax(), this.energyStorage.getEnergyStored()), false);
                this.energyStorage.modifyEnergyStored(extract);
                this.isTransferringPower = !tile.toString().contains("conduit") || extract != -75;
            } else {
                this.isTransferringPower = false;
            }
        } else {
            this.isTransferringPower = false;
        }
    }

    public float getAngle() {
        return (float)this.angle;
    }

    public float getExternalAngle() {
        return (float)this.angle_external;
    }

    public void animate() {
        if (Extra.TURBINE_ANIM) {
            if (!this.field_70331_k.field_72995_K && this.onTick(Extra.TURBINE_RATE)) {
                this.isAnimating = this.isCreatingPower || this.isTransferringPower;
                Packets.updateTile(this, new Packet119TurbineAnimate(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.isAnimating).build());
            } else if (this.field_70331_k.field_72995_K && this.isAnimating) {
                this.angle += 0.1;
                this.angle_external += 0.01;
                if (this.energyStage == EnergyStage.GREEN) {
                    this.angle += 0.1;
                }
                if (this.energyStage == EnergyStage.YELLOW) {
                    this.angle += 0.15;
                }
                if (this.energyStage == EnergyStage.RED) {
                    this.angle += 0.15;
                }
                this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
    }

    protected EnergyStage computeEnergyStage() {
        if (this.speed <= 2) {
            return EnergyStage.BLUE;
        }
        if (this.speed <= 4) {
            return EnergyStage.GREEN;
        }
        if (this.speed <= 8) {
            return EnergyStage.YELLOW;
        }
        if (this.speed <= 20) {
            return EnergyStage.ORANGE;
        }
        return EnergyStage.RED;
    }

    public boolean switchOrientation() {
        for (int i = this.direction.ordinal() + 1; i <= this.direction.ordinal() + 6; ++i) {
            ForgeDirection facing = ForgeDirection.VALID_DIRECTIONS[i % 6];
            TileEntity tile = BlockHelper.getAdjacentTileEntity(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, facing);
            if (!(tile instanceof IEnergyHandler) || !((IEnergyHandler)tile).canInterface(facing)) continue;
            this.direction = facing;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
            return true;
        }
        return false;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public boolean canInterface(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public String getPowerText() {
        return this.getEnergyStored(ForgeDirection.UNKNOWN) + " / " + this.getMaxEnergyStored(ForgeDirection.UNKNOWN) + " RF";
    }

    @Override
    public int getPowerScaled(int i) {
        return this.energyStorage.getEnergyStored() * i / this.energyStorage.getMaxEnergyStored();
    }

    public Packet func_70319_e() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_70310_b(tagCompound);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 2, tagCompound);
    }

    public void onDataPacket(INetworkManager netManager, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        switch (id) {
            case 0: {
                this.mode = FeatureRedstone.RedstoneMode.values()[value];
                break;
            }
            case 1: {
                this.tank.setFluidID(value);
                break;
            }
            case 2: {
                this.tank.setFluidAmount(value);
                break;
            }
            case 3: {
                this.tank.setCapacity(value);
                break;
            }
            case 4: {
                this.energyStorage.setEnergyStored(value);
                break;
            }
            case 5: {
                this.energyStorage.setCapacity(value);
            }
        }
    }

    @Override
    public void sendGUINetworkData(ContainerMariculture container, EntityPlayer player) {
        Packets.updateGUI(player, container, 0, this.mode.ordinal());
        Packets.updateGUI(player, container, 1, this.tank.getFluidID());
        Packets.updateGUI(player, container, 2, this.tank.getFluidAmount());
        Packets.updateGUI(player, container, 3, this.tank.getCapacity());
        Packets.updateGUI(player, container, 4, this.energyStorage.getEnergyStored());
        Packets.updateGUI(player, container, 5, this.energyStorage.getMaxEnergyStored());
    }

    @Override
    public FeatureRedstone.RedstoneMode getRSMode() {
        return this.mode != null ? this.mode : FeatureRedstone.RedstoneMode.DISABLED;
    }

    @Override
    public void setRSMode(FeatureRedstone.RedstoneMode mode) {
        this.mode = mode;
    }

    public boolean isNotificationVisible(FeatureNotifications.NotificationType type) {
        switch (type) {
            default: 
        }
        return false;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.energyStorage.readFromNBT(nbt);
        this.mode = FeatureRedstone.RedstoneMode.readFromNBT(nbt);
        this.purity = nbt.func_74762_e("Purity");
        this.heat = nbt.func_74762_e("Heat");
        this.storage = nbt.func_74762_e("Storage");
        this.speed = nbt.func_74762_e("Speed");
        this.rf = nbt.func_74762_e("RF");
        this.direction = ForgeDirection.getOrientation((int)nbt.func_74762_e("Orientation"));
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        this.energyStorage.writeToNBT(nbt);
        FeatureRedstone.RedstoneMode.writeToNBT(nbt, this.mode);
        nbt.func_74768_a("Purity", this.purity);
        nbt.func_74768_a("Heat", this.heat);
        nbt.func_74768_a("Storage", this.storage);
        nbt.func_74768_a("Speed", this.speed);
        nbt.func_74768_a("RF", this.rf);
        nbt.func_74768_a("Orientation", this.direction.ordinal());
    }

    public static enum EnergyStage {
        BLUE,
        GREEN,
        YELLOW,
        ORANGE,
        RED;

    }
}

