/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.blocks;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.TileEnergyHandler;
import mariculture.core.lib.Modules;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;

public class TileSponge
extends TileEnergyHandler {
    boolean posXFound;
    boolean negXFound;
    boolean posZFound;
    boolean negZFound;
    boolean posYFound = false;
    int posX;
    int negX;
    int posZ;
    int negZ;
    int posY = 0;
    private int tick;

    public TileSponge() {
        this.storage = new EnergyStorage(0, 5000, Integer.MAX_VALUE);
    }

    public boolean isBlockSponge(int x, int y, int z) {
        if (Modules.isActive(Modules.worldplus)) {
            return this.field_70331_k.func_72798_a(x, y, z) == Block.field_71945_L.field_71990_ca;
        }
        return this.field_70331_k.func_72798_a(x, y, z) == Block.field_72101_ab.field_71990_ca && this.field_70331_k.func_72805_g(x, y, z) == 4;
    }

    public void updateCoords() {
        this.posXFound = false;
        this.negXFound = false;
        this.posZFound = false;
        this.negZFound = false;
        this.posYFound = false;
        for (int i = 0; i < 48; ++i) {
            if (!this.posXFound && this.isBlockSponge(this.field_70329_l + i, this.field_70330_m, this.field_70327_n)) {
                this.posXFound = true;
                this.posX = this.field_70329_l + i;
            }
            if (!this.negXFound && this.isBlockSponge(this.field_70329_l - i, this.field_70330_m, this.field_70327_n)) {
                this.negXFound = true;
                this.negX = this.field_70329_l - i;
            }
            if (!this.posZFound && this.isBlockSponge(this.field_70329_l, this.field_70330_m, this.field_70327_n + i)) {
                this.posZFound = true;
                this.posZ = this.field_70327_n + i;
            }
            if (!this.negZFound && this.isBlockSponge(this.field_70329_l, this.field_70330_m, this.field_70327_n - i)) {
                this.negZFound = true;
                this.negZ = this.field_70327_n - i;
            }
            if (this.posYFound || !this.isBlockSponge(this.field_70329_l, this.field_70330_m + i, this.field_70327_n)) continue;
            this.posYFound = true;
            this.posY = this.field_70330_m + i;
        }
    }

    public void clearWater() {
        for (int x = this.negX; x <= this.posX; ++x) {
            for (int z = this.negZ; z <= this.posZ; ++z) {
                for (int y = this.field_70330_m; y <= this.posY; ++y) {
                    if (!this.field_70331_k.func_72803_f(x, y, z).func_76224_d() && this.field_70331_k.func_72798_a(x, y, z) != Block.field_71945_L.field_71990_ca) continue;
                    this.field_70331_k.func_94571_i(x, y, z);
                }
            }
        }
    }

    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K) {
            if (this.tick % 50 == 0) {
                this.updateCoords();
            }
            ++this.tick;
            if (this.tick % 200 == 0) {
                if (this.posXFound && this.negXFound && this.posZFound && this.negZFound && this.posYFound) {
                    int powerX = Math.max(this.posX, this.negX) - Math.min(this.posX, this.negX);
                    int powerZ = Math.max(this.posZ, this.negZ) - Math.min(this.posZ, this.negZ);
                    int powerY = Math.max(this.field_70330_m, this.posY) - Math.min(this.field_70330_m, this.posY);
                    int power = powerX * powerZ * powerY * 40;
                    this.storage.setCapacity(power);
                    if (this.storage.extractEnergy(power, true) >= power) {
                        this.clearWater();
                        this.storage.extractEnergy(power, false);
                        this.storage.setCapacity(0);
                    }
                } else {
                    this.storage.setCapacity(0);
                }
            }
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound tagCompound) {
        super.func_70307_a(tagCompound);
        this.storage.readFromNBT(tagCompound);
    }

    @Override
    public void func_70310_b(NBTTagCompound tagCompound) {
        super.func_70310_b(tagCompound);
        this.storage.writeToNBT(tagCompound);
    }
}

