/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.blocks;

import mariculture.api.core.MaricultureHandlers;
import mariculture.core.Core;
import mariculture.core.blocks.base.TileMachine;
import mariculture.core.gui.ContainerMariculture;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.gui.feature.FeatureNotifications;
import mariculture.core.gui.feature.FeatureRedstone;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.lib.MachineSpeeds;
import mariculture.core.lib.PlansMeta;
import mariculture.core.network.Packets;
import mariculture.core.util.IHasNotification;
import mariculture.core.util.IProgressable;
import mariculture.core.util.Rand;
import mariculture.factory.Factory;
import mariculture.factory.blocks.BlockItemCustom;
import mariculture.factory.blocks.BlockItemCustomSlabBase;
import mariculture.factory.items.ItemPlan;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileSawmill
extends TileMachine
implements IHasNotification,
IProgressable {
    public int selected = 3;
    public static final int TOP = 6;
    public static final int NORTH = 7;
    public static final int SOUTH = 8;
    public static final int WEST = 9;
    public static final int EAST = 10;
    public static final int BOTTOM = 11;
    public static final int OUT = 12;

    public TileSawmill() {
        this.max = MachineSpeeds.getSawmillSpeed();
        this.inventory = new ItemStack[13];
    }

    public int[] func_94128_d(int side) {
        switch (side) {
            case 0: {
                return new int[]{3, 4, 5, 11, 12};
            }
            case 1: {
                return new int[]{3, 4, 5, 6, 12};
            }
            case 2: {
                return new int[]{3, 4, 5, 7, 12};
            }
            case 3: {
                return new int[]{3, 4, 5, 8, 12};
            }
            case 4: {
                return new int[]{3, 4, 5, 9, 12};
            }
            case 5: {
                return new int[]{3, 4, 5, 10, 12};
            }
        }
        return null;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (slot == 12) {
            return false;
        }
        if (slot < 6) {
            return stack.field_77993_c == Factory.plans.field_77779_bT;
        }
        if (stack.func_77973_b() instanceof BlockItemCustom || stack.func_77973_b() instanceof BlockItemCustomSlabBase) {
            return false;
        }
        return stack.func_77973_b() instanceof ItemBlock || stack.func_77973_b().field_77779_bT == Item.field_77676_L.field_77779_bT;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 12;
    }

    @Override
    public FeatureEject.EjectSetting getEjectType() {
        return FeatureEject.EjectSetting.ITEM;
    }

    @Override
    public void updateMachine() {
        if (this.canWork) {
            this.processed += this.speed;
            if (this.processed >= this.max && this.canWork()) {
                this.processed = 0;
                this.saw();
            }
        } else {
            this.processed = 0;
        }
    }

    @Override
    public boolean canWork() {
        return this.hasPlanSelected() && this.allSidesFilled() && FeatureRedstone.RedstoneMode.canWork(this, this.mode) && this.outputHasRoom();
    }

    private boolean hasPlanSelected() {
        return this.inventory[this.selected] != null && this.inventory[this.selected].func_77973_b() instanceof ItemPlan;
    }

    private boolean allSidesFilled() {
        return this.inventory[6] != null && this.inventory[11] != null && this.inventory[7] != null && this.inventory[8] != null && this.inventory[10] != null && this.inventory[9] != null;
    }

    private boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        if (!stack1.func_77969_a(stack2)) {
            return false;
        }
        if (stack1.func_77942_o() && stack2.func_77942_o()) {
            return PlansMeta.isSame(stack1, stack2);
        }
        return stack1.field_77990_d == null && stack2.field_77990_d == null;
    }

    private boolean outputHasRoom() {
        if (this.setting.canEject(FeatureEject.EjectSetting.ITEM)) {
            return true;
        }
        ItemStack result = this.getResult();
        return this.inventory[12] == null || this.areStacksEqual(this.inventory[12], result) && this.inventory[12].field_77994_a + result.field_77994_a < this.inventory[12].func_77976_d();
    }

    public void saw() {
        ItemStack result = this.getResult();
        this.helper.insertStack(result, new int[]{12});
        for (int i = 6; i < 12; ++i) {
            --this.inventory[i].field_77994_a;
            if (this.inventory[i].field_77994_a != 0) continue;
            Item var2 = this.inventory[i].func_77973_b().func_77668_q();
            this.inventory[i] = var2 == null ? null : new ItemStack(var2);
        }
        this.inventory[this.selected].func_96631_a(1, Rand.rand);
        if (this.inventory[this.selected].func_77960_j() > this.inventory[this.selected].func_77958_k()) {
            this.inventory[this.selected] = null;
        }
        this.canWork = this.canWork();
    }

    public ItemStack getResult() {
        ItemStack stack = PlansMeta.getBlockStack(PlansMeta.getType(this.inventory[this.selected]));
        stack.func_77982_d(new NBTTagCompound());
        int[] ids = new int[]{this.getID(11), this.getID(6), this.getID(7), this.getID(8), this.getID(9), this.getID(10)};
        int[] metas = new int[]{this.getMeta(11), this.getMeta(6), this.getMeta(7), this.getMeta(8), this.getMeta(9), this.getMeta(10)};
        String name = BlockHelper.getName(this.inventory[6]) + " - " + stack.func_82833_r();
        stack.field_77990_d.func_74783_a("BlockIDs", ids);
        stack.field_77990_d.func_74783_a("BlockMetas", metas);
        stack.field_77990_d.func_74783_a("BlockSides", new int[]{0, 1, 2, 3, 4, 5});
        stack.field_77990_d.func_74778_a("Name", name);
        stack.field_77994_a = ((ItemPlan)this.inventory[this.selected].func_77973_b()).getStackSize(this.inventory[this.selected]);
        if (MaricultureHandlers.upgrades.hasUpgrade("ethereal", this)) {
            stack.field_77994_a *= 2;
        }
        return stack;
    }

    private int getID(int slot) {
        if (this.inventory[slot].field_77993_c == Item.field_77676_L.field_77779_bT) {
            return Core.air.field_71990_ca;
        }
        return this.inventory[slot].field_77993_c;
    }

    private int getMeta(int slot) {
        if (this.inventory[slot].field_77993_c == Item.field_77676_L.field_77779_bT) {
            return 1;
        }
        return this.inventory[slot].func_77960_j();
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        super.getGUINetworkData(id, value);
        if (id - this.offset == 0) {
            this.selected = value;
        }
    }

    @Override
    public void sendGUINetworkData(ContainerMariculture container, EntityPlayer player) {
        super.sendGUINetworkData(container, player);
        Packets.updateGUI(player, container, 0 + this.offset, this.selected);
    }

    @Override
    public boolean isNotificationVisible(FeatureNotifications.NotificationType type) {
        switch (type) {
            case NO_PLAN: {
                return !this.hasPlanSelected();
            }
            case MISSING_SIDE: {
                return !this.allSidesFilled();
            }
        }
        return false;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.selected = nbt.func_74762_e("PlanSelected");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("PlanSelected", this.selected);
    }
}

