/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.blocks;

import java.util.List;
import mariculture.core.Core;
import mariculture.core.blocks.BlockOyster;
import mariculture.core.blocks.base.TileTank;
import mariculture.core.helpers.SpawnItemHelper;
import mariculture.core.helpers.cofh.InventoryHelper;
import mariculture.core.lib.Extra;
import mariculture.core.network.Packets;
import mariculture.core.util.FluidDictionary;
import mariculture.core.util.Tank;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLogic;
import net.minecraft.block.material.MaterialTransparent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileGeyser
extends TileTank {
    public ForgeDirection orientation = ForgeDirection.UP;
    private int machineTick;
    private boolean canWork;
    private int size;

    public TileGeyser() {
        this.tank = new Tank(8000);
    }

    public boolean onTick(int i) {
        return this.machineTick % i == 0;
    }

    public boolean canUpdate() {
        return true;
    }

    public boolean canWork() {
        return this.tank.getFluidAmount() > 0 && this.canUseFluid(this.tank.getFluidID()) && !this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    private boolean canUseFluid(int id) {
        if (id == FluidRegistry.getFluidID((String)"water")) {
            this.size = 8;
            return true;
        }
        if (id == FluidRegistry.getFluidID((String)FluidDictionary.hp_water)) {
            this.size = 16;
            return true;
        }
        return false;
    }

    private boolean isNet(int x, int y, int z) {
        return this.field_70331_k.func_72798_a(x, y, z) == Core.oyster.field_71990_ca && this.field_70331_k.func_72805_g(x, y, z) == BlockOyster.NET;
    }

    public void func_70316_g() {
        ++this.machineTick;
        if (this.onTick(Extra.CAN_WORK_TICK)) {
            this.canWork = this.canWork();
        }
        if (this.canWork) {
            this.doSquirt();
            if (this.onTick(100)) {
                this.drain(ForgeDirection.UP, new FluidStack(this.tank.getFluidID(), 1), true);
                Packets.updateTile(this, this.func_70319_e());
                this.pullFromInventory();
            }
        }
    }

    private void doSquirt() {
        for (int dist = 0; dist < this.size; ++dist) {
            float i;
            Material mat;
            double x = this.field_70329_l + this.orientation.offsetX * dist;
            double y = this.field_70330_m + this.orientation.offsetY * dist;
            double z = this.field_70327_n + this.orientation.offsetZ * dist;
            if (!(dist <= 0 || (mat = this.field_70331_k.func_72803_f((int)x, (int)y, (int)z)) instanceof MaterialLogic || mat instanceof MaterialTransparent || this.isNet((int)x, (int)y, (int)z))) {
                return;
            }
            List list = this.field_70331_k.func_72872_a(Entity.class, Block.field_71981_t.func_71872_e(this.field_70331_k, (int)x, (int)y, (int)z));
            for (Object i2 : list) {
                Entity entity = (Entity)i2;
                entity.field_70143_R = 0.0f;
                entity.func_70066_B();
                if (this.orientation != ForgeDirection.UP) {
                    entity.func_70024_g((double)this.orientation.offsetX * 0.1, (double)this.orientation.offsetY * 0.1, (double)this.orientation.offsetZ * 0.1);
                    continue;
                }
                if (!(entity.field_70181_x <= 0.24)) continue;
                entity.field_70181_x += 0.25;
                if (!(entity instanceof EntityItem)) continue;
                entity.field_70181_x += 0.015;
                entity.field_70159_w = 0.0;
                entity.field_70179_y = 0.0;
            }
            if (!Extra.GEYSER_ANIM || !this.field_70331_k.field_72995_K || !this.onTick(4)) continue;
            float f = i = dist > 0 ? -0.45f : -0.1f;
            while (i <= 0.35f) {
                this.field_70331_k.func_72869_a("cloud", x + 0.5 + (double)(i * (float)this.orientation.offsetX), y + 0.5 + (double)(i * (float)this.orientation.offsetY), z + 0.5 + (double)(i * (float)this.orientation.offsetZ), 0.0, 0.0, 0.0);
                i += 0.05f;
            }
        }
    }

    public void pullFromInventory() {
        TileEntity tile = this.field_70331_k.func_72796_p(this.field_70329_l - this.orientation.offsetX, this.field_70330_m - this.orientation.offsetY, this.field_70327_n - this.orientation.offsetZ);
        if (tile != null && tile instanceof IInventory) {
            ItemStack stack = InventoryHelper.extractItemStackFromInventory((IInventory)tile, this.orientation.getOpposite().ordinal());
            if (stack != null) {
                SpawnItemHelper.spawnItem(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, stack, false);
            }
        } else if (tile != null && tile instanceof IFluidHandler) {
            FluidStack fluid;
            IFluidHandler handler = (IFluidHandler)tile;
            if (this.tank.getFluidAmount() + 1000 < this.tank.getCapacity() && (fluid = handler.drain(this.orientation.getOpposite(), 1000, true)) != null) {
                this.tank.fill(fluid, true);
            }
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 2, nbt);
    }

    public void onDataPacket(INetworkManager netManager, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.orientation = ForgeDirection.getOrientation((int)nbt.func_74762_e("Orientation"));
        this.canWork = nbt.func_74767_n("CanWork");
        this.size = nbt.func_74762_e("Size");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("Orientation", this.orientation.ordinal());
        nbt.func_74757_a("CanWork", this.canWork);
        nbt.func_74768_a("Size", this.size);
    }
}

