/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.blocks;

import java.util.List;
import mariculture.api.core.MaricultureHandlers;
import mariculture.core.Core;
import mariculture.core.blocks.BlockOyster;
import mariculture.core.blocks.base.TileMachineTank;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.gui.feature.FeatureNotifications;
import mariculture.core.gui.feature.FeatureRedstone;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.helpers.cofh.InventoryHelper;
import mariculture.core.lib.MaricultureDamage;
import mariculture.core.network.Packets;
import mariculture.core.util.FluidDictionary;
import mariculture.core.util.IHasNotification;
import mariculture.core.util.Rand;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLogic;
import net.minecraft.block.material.MaterialTransparent;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.FakePlayer;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileFLUDDStand
extends TileMachineTank
implements IHasNotification {
    public ForgeDirection orientation = ForgeDirection.UP;
    public static final int input = 3;
    public static final int output = 4;

    public TileFLUDDStand() {
        this.mode = FeatureRedstone.RedstoneMode.HIGH;
    }

    @Override
    public int getTankCapacity(int count) {
        return 20000 + count * 4000;
    }

    public int[] func_94128_d(int side) {
        return new int[]{3, 4};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot == 3 && FluidHelper.isFluidOrEmpty(stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 4;
    }

    @Override
    public void updateMachine() {
        if (this.canWork) {
            this.doSquirt();
            if (this.onTick(100)) {
                this.drain(ForgeDirection.UP, new FluidStack(this.tank.getFluidID(), this.getWaterUsage()), true);
                Packets.updateTile(this, this.func_70319_e());
            }
        }
    }

    private void doSquirt() {
        float hardnessMax = -this.heat * 2;
        boolean reverse = this.hasEthereal();
        double boostXZ = this.getBoostXZ();
        double boostY = this.getBoostY();
        for (int dist = 0; dist < this.getDistance(); ++dist) {
            float i;
            int z2;
            int y2;
            int x2;
            Block block;
            Material mat;
            double x = this.field_70329_l + this.orientation.offsetX * dist;
            double y = this.field_70330_m + this.orientation.offsetY * dist;
            double z = this.field_70327_n + this.orientation.offsetZ * dist;
            if (!(dist <= 0 || (mat = this.field_70331_k.func_72803_f((int)x, (int)y, (int)z)) instanceof MaterialLogic || mat instanceof MaterialTransparent || this.isNet((int)x, (int)y, (int)z))) {
                return;
            }
            List list = this.field_70331_k.func_72872_a(Entity.class, Block.field_71981_t.func_71872_e(this.field_70331_k, (int)x, (int)y, (int)z));
            for (Object i2 : list) {
                Entity entity = (Entity)i2;
                entity.field_70143_R = 0.0f;
                if (dist == 1 && !this.field_70331_k.field_72995_K && this.onTick(20) && reverse && entity instanceof EntityItem) {
                    EntityItem item = (EntityItem)entity;
                    ItemStack stack = item.func_92059_d();
                    TileEntity tile = this.field_70331_k.func_72796_p(this.field_70329_l - this.orientation.offsetX, this.field_70330_m - this.orientation.offsetY, this.field_70327_n - this.orientation.offsetZ);
                    if (tile != null && tile instanceof IInventory) {
                        ItemStack newStack = InventoryHelper.insertItemStackIntoInventory((IInventory)tile, stack, this.orientation.getOpposite().ordinal());
                        if (newStack == null) {
                            item.func_70106_y();
                        } else {
                            item.func_92058_a(newStack);
                        }
                    }
                }
                if (this.orientation != ForgeDirection.UP) {
                    if (reverse) {
                        entity.func_70024_g((double)(-this.orientation.offsetX) * boostXZ, (double)(-this.orientation.offsetY) * boostXZ, (double)(-this.orientation.offsetZ) * boostXZ);
                    } else {
                        entity.func_70024_g((double)this.orientation.offsetX * boostXZ, (double)this.orientation.offsetY * boostXZ, (double)this.orientation.offsetZ * boostXZ);
                    }
                } else if (entity.field_70181_x <= boostY - 0.1) {
                    entity.field_70181_x += boostY;
                    if (entity instanceof EntityItem) {
                        entity.field_70181_x += 0.015;
                        entity.field_70159_w = 0.0;
                        entity.field_70179_y = 0.0;
                    }
                }
                if (this.heat <= 0 || !(entity instanceof EntityLivingBase)) continue;
                entity.func_70097_a(MaricultureDamage.scald, (float)(this.heat / 2));
            }
            if (this.heat < 0 && (block = Block.field_71973_m[this.field_70331_k.func_72798_a(x2 = (int)(x + (double)this.orientation.offsetX), y2 = (int)(y + (double)this.orientation.offsetY), z2 = (int)(z + (double)this.orientation.offsetZ))]) != null) {
                int chance;
                float blockHardness = block.func_71934_m(this.field_70331_k, x2, y2, z2);
                if (this.field_70331_k.field_72995_K) {
                    block.addBlockHitEffects(this.field_70331_k, new MovingObjectPosition(x2, y2, z2, this.orientation.getOpposite().ordinal(), this.field_70331_k.func_82732_R().func_72345_a((double)x2, (double)y2, (double)z2)), Minecraft.func_71410_x().field_71452_i);
                }
                if (Rand.nextInt(chance = (int)(blockHardness * 10.0f > 0.0f ? blockHardness * 10.0f : 10.0f)) && blockHardness <= hardnessMax) {
                    FakePlayer player;
                    int meta = this.field_70331_k.func_72805_g(x2, y2, z2);
                    if (this.field_70331_k.field_72995_K) {
                        block.addBlockDestroyEffects(this.field_70331_k, x2, y2, z2, meta, Minecraft.func_71410_x().field_71452_i);
                    }
                    if (block.removeBlockByPlayer(this.field_70331_k, (EntityPlayer)(player = new FakePlayer(this.field_70331_k, "fludd")), x2, y2, z2)) {
                        block.func_71898_d(this.field_70331_k, x2, y2, z2, meta);
                    }
                    block.func_71893_a(this.field_70331_k, (EntityPlayer)player, x2, y2, z2, meta);
                    block.func_71846_a(this.field_70331_k, x2, y2, z2, meta, (EntityPlayer)player);
                }
            }
            if (!this.field_70331_k.field_72995_K || !this.onTick(4)) continue;
            float f = i = dist > 0 ? -0.45f : 0.3f;
            while (i <= 0.35f) {
                this.field_70331_k.func_72869_a("cloud", x + 0.5 + (double)(i * (float)this.orientation.offsetX), y + (double)0.7f + (double)(i * (float)this.orientation.offsetY), z + 0.5 + (double)(i * (float)this.orientation.offsetZ), 0.0, 0.0, 0.0);
                i += 0.05f;
            }
        }
    }

    @Override
    public boolean canWork() {
        return this.tank.getFluidAmount() > 0 && this.tank.getFluidID() == FluidRegistry.getFluidID((String)FluidDictionary.hp_water) && FeatureRedstone.RedstoneMode.canWork(this, this.mode);
    }

    private boolean isNet(int x, int y, int z) {
        return this.field_70331_k.func_72798_a(x, y, z) == Core.oyster.field_71990_ca && this.field_70331_k.func_72805_g(x, y, z) == BlockOyster.NET;
    }

    private boolean hasEthereal() {
        return MaricultureHandlers.upgrades.hasUpgrade("ethereal", this);
    }

    private int getWaterUsage() {
        return this.getDistance() / 8 + (this.heat >= 0 ? this.heat : -this.heat) + (this.hasEthereal() ? 10 : 0) + this.speed;
    }

    private int getDistance() {
        return (this.purity + 1) * 8;
    }

    private double getBoostXZ() {
        return (double)this.speed * 0.025;
    }

    private double getBoostY() {
        double boost = this.speed <= 4 ? 0.15 : (this.speed <= 8 ? 0.1 : (this.speed <= 12 ? 0.05 : 0.025));
        return (double)this.speed * boost;
    }

    @Override
    public FeatureEject.EjectSetting getEjectType() {
        return FeatureEject.EjectSetting.FLUID;
    }

    @Override
    public boolean isNotificationVisible(FeatureNotifications.NotificationType type) {
        return false;
    }

    public Packet func_70319_e() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 2, nbt);
    }

    public void onDataPacket(INetworkManager netManager, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.orientation = ForgeDirection.values()[nbt.func_74762_e("Orientation")];
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("Orientation", this.orientation.ordinal());
    }
}

