/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.blocks;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import java.util.ArrayList;
import mariculture.core.util.PowerHelper;
import mariculture.factory.blocks.TileCustom;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public class TileCustomPowered
extends TileCustom
implements IEnergyHandler {
    private int tick;
    private ForgeDirection cameFrom;
    private EnergyStorage storage = new EnergyStorage(1000);
    public static ArrayList<Object[]> handlers = new ArrayList();

    @Override
    public void func_70307_a(NBTTagCompound tagCompound) {
        super.func_70307_a(tagCompound);
        this.storage.readFromNBT(tagCompound);
    }

    @Override
    public void func_70310_b(NBTTagCompound tagCompound) {
        super.func_70310_b(tagCompound);
        this.storage.writeToNBT(tagCompound);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        this.cameFrom = from;
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public boolean canInterface(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_70316_g() {
        if (this.storage.getEnergyStored() > 0) {
            ++this.tick;
            if (this.tick % 5 == 0) {
                IEnergyHandler handler = null;
                Object[] res = PowerHelper.getNextEnergyHandler(this.cameFrom, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
                if (res[0] != null) {
                    handler = (IEnergyHandler)res[0];
                    this.cameFrom = (ForgeDirection)res[1];
                }
                if (handler != null && handler.canInterface(this.cameFrom)) {
                    this.storage.modifyEnergyStored(-handler.receiveEnergy(this.cameFrom.getOpposite(), Math.min(this.storage.getMaxEnergyStored(), this.storage.getEnergyStored()), false));
                    return;
                }
            }
        }
    }

    static {
        handlers.add(new Object[]{-1, 0, 0, ForgeDirection.WEST});
        handlers.add(new Object[]{0, 0, 1, ForgeDirection.SOUTH});
        handlers.add(new Object[]{0, 1, 0, ForgeDirection.UP});
        handlers.add(new Object[]{0, 0, -1, ForgeDirection.NORTH});
        handlers.add(new Object[]{1, 0, 0, ForgeDirection.EAST});
        handlers.add(new Object[]{0, -1, 0, ForgeDirection.DOWN});
    }
}

