/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mariculture.api.core.MaricultureRegistry;
import mariculture.core.util.IItemRegistry;
import mariculture.factory.blocks.BlockCustomHelper;
import mariculture.factory.blocks.TileCustom;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockCustomFence
extends BlockFence
implements IItemRegistry {
    public BlockCustomFence(int i) {
        super(i, "customFence", Material.field_76246_e);
        this.func_71849_a(null);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        return Block.field_71981_t.func_71858_a(side, meta);
    }

    public Icon func_71895_b(IBlockAccess block, int x, int y, int z, int side) {
        return BlockCustomHelper.getBlockTexture(block, x, y, z, side);
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        super.func_71860_a(world, x, y, z, entity, stack);
        BlockCustomHelper.onBlockPlacedBy(world, x, y, z, entity, stack);
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        return BlockCustomHelper.rotateBlock(world, x, y, z, axis);
    }

    public float func_71934_m(World world, int x, int y, int z) {
        return BlockCustomHelper.getBlockHardness(world, x, y, z);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return BlockCustomHelper.getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, World world, int x, int y, int z) {
        return false;
    }

    public int func_71925_a(Random rand) {
        return 0;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return BlockCustomHelper.removeBlockByPlayer(world, player, x, y, z, this.getID());
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return BlockCustomHelper.getPickBlock(target, world, x, y, z, this.getID());
    }

    private int getID() {
        return 4;
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileCustom();
    }

    @Override
    public void register() {
        for (int j = 0; j < this.getMetaCount(); ++j) {
            MaricultureRegistry.register(this.getName(new ItemStack(this.field_71990_ca, 1, j)), new ItemStack(this.field_71990_ca, 1, j));
        }
    }

    @Override
    public int getMetaCount() {
        return 1;
    }

    @Override
    public String getName(ItemStack stack) {
        return "customFence";
    }

    public void func_94332_a(IconRegister par1IconRegister) {
    }
}

