/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.world;

import java.util.Random;
import mariculture.core.Core;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.lib.OreGeneration;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenLimestone
extends WorldGenerator {
    private int numberOfBlocks;

    public WorldGenLimestone(int par2) {
        this.numberOfBlocks = par2;
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        return this.func_76484_a(world, random, i, world.func_72825_h(i, k), k);
    }

    public boolean generate(World world, Random random, int xCoord, int zCoord) {
        float f = random.nextFloat() * (float)Math.PI;
        double d = (float)(xCoord + 8) + MathHelper.func_76126_a((float)f) * (float)this.numberOfBlocks / 8.0f;
        double d1 = (float)(xCoord + 8) - MathHelper.func_76126_a((float)f) * (float)this.numberOfBlocks / 8.0f;
        double d2 = (float)(zCoord + 8) + MathHelper.func_76134_b((float)f) * (float)this.numberOfBlocks / 8.0f;
        double d3 = (float)(zCoord + 8) - MathHelper.func_76134_b((float)f) * (float)this.numberOfBlocks / 8.0f;
        double d4 = world.func_72825_h(xCoord, zCoord);
        double d5 = world.func_72825_h(xCoord, zCoord);
        for (int i = 0; i <= this.numberOfBlocks; ++i) {
            double d6 = d + (d1 - d) * (double)i / (double)this.numberOfBlocks;
            double d7 = d4 + (d5 - d4) * (double)i / (double)this.numberOfBlocks;
            double d8 = d2 + (d3 - d2) * (double)i / (double)this.numberOfBlocks;
            double d9 = random.nextDouble() * (double)this.numberOfBlocks / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)this.numberOfBlocks)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)this.numberOfBlocks)) + 1.0f) * d9 + 1.0;
            int j = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int k = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int l = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int i1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int x = j; x <= i1; ++x) {
                double d12 = ((double)x + 0.5 - d6) / (d10 / 2.0);
                if (d12 * d12 >= 1.0) continue;
                for (int y = k; y <= j1; ++y) {
                    double d13 = ((double)y + 0.5 - d7) / (d11 / 2.0);
                    if (d12 * d12 + d13 * d13 >= 1.0) continue;
                    for (int z = l; z <= k1; ++z) {
                        double d14 = ((double)z + 0.5 - d8) / (d10 / 2.0);
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0) || y >= 64 || !this.isValidPlacement(world, x, y, z)) continue;
                        if (OreGeneration.RUTILE && random.nextInt(OreGeneration.RUTILE_CHANCE) == 0) {
                            world.func_72832_d(x, y, z, Core.ores.field_71990_ca, 2, 2);
                            continue;
                        }
                        world.func_72832_d(x, y, z, Core.ores.field_71990_ca, 3, 2);
                    }
                }
            }
        }
        return true;
    }

    private boolean isNotWater(World world, int x, int y, int z) {
        return world.func_72803_f(x, y, z) == Material.field_76244_g && !BlockHelper.isWater(world, x, y, z);
    }

    private boolean isValidPlacement(World world, int x, int y, int z) {
        if (!world.func_72863_F().func_73149_a(x >> 4, z >> 4)) {
            return false;
        }
        try {
            if (this.isNotWater(world, x, y + 1, z) || this.isNotWater(world, x, y + 2, z)) {
                return false;
            }
            int id = world.func_72798_a(x, y, z);
            if (id == Core.ores.field_71990_ca) {
                return false;
            }
            if (id == Block.field_71979_v.field_71990_ca) {
                return true;
            }
            if (id == Block.field_71939_E.field_71990_ca) {
                return true;
            }
            if (id == Block.field_72041_aW.field_71990_ca) {
                return true;
            }
            return world.func_72803_f(x, y, z) == Material.field_76246_e;
        }
        catch (Exception e) {
            return false;
        }
    }
}

