/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.network;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mariculture.core.network.PacketMariculture;
import mariculture.fishery.blocks.TileFishTank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Packet121FishTankSync
extends PacketMariculture {
    public NBTTagCompound nbt;

    public Packet121FishTankSync() {
    }

    public Packet121FishTankSync(int xCoord, int yCoord, int zCoord, HashMap fish) {
        this.nbt = new NBTTagCompound();
        this.nbt.func_74768_a("x", xCoord);
        this.nbt.func_74768_a("y", yCoord);
        this.nbt.func_74768_a("z", zCoord);
        NBTTagList itemList = new NBTTagList();
        Iterator it = fish.entrySet().iterator();
        while (it.hasNext()) {
            NBTTagCompound tag = new NBTTagCompound();
            Map.Entry pairs = it.next();
            tag.func_74768_a("Key", ((Integer)pairs.getKey()).intValue());
            ItemStack stack = (ItemStack)pairs.getValue();
            if (stack != null) {
                stack.func_77955_b(tag);
            }
            itemList.func_74742_a((NBTBase)tag);
        }
        this.nbt.func_74782_a("FishList", (NBTBase)itemList);
    }

    @Override
    public void handle(World world, EntityPlayer player) {
        int z;
        int y;
        int x = this.nbt.func_74762_e("x");
        TileEntity tile = world.func_72796_p(x, y = this.nbt.func_74762_e("y"), z = this.nbt.func_74762_e("z"));
        if (tile instanceof TileFishTank) {
            TileFishTank tank = (TileFishTank)tile;
            NBTTagList tagList = this.nbt.func_74761_m("FishList");
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = (NBTTagCompound)tagList.func_74743_b(i);
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tag);
                tank.fish.put(tag.func_74762_e("Key"), stack);
            }
        }
        world.func_72902_n(x, y, z);
    }

    @Override
    public void read(DataInputStream is) throws IOException {
        this.nbt = CompressedStreamTools.func_74794_a((DataInput)is);
    }

    @Override
    public void write(DataOutputStream os) throws IOException {
        CompressedStreamTools.func_74800_a((NBTTagCompound)this.nbt, (DataOutput)os);
    }
}

