/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.network;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import mariculture.core.blocks.TileAnvil;
import mariculture.core.blocks.TileCooling;
import mariculture.core.blocks.TileVat;
import mariculture.core.network.PacketMariculture;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Packet120ItemSync
extends PacketMariculture {
    public NBTTagCompound nbt;

    public Packet120ItemSync() {
    }

    public Packet120ItemSync(int xCoord, int yCoord, int zCoord, ItemStack[] inventory) {
        this.nbt = new NBTTagCompound();
        this.nbt.func_74768_a("x", xCoord);
        this.nbt.func_74768_a("y", yCoord);
        this.nbt.func_74768_a("z", zCoord);
        this.nbt.func_74768_a("length", inventory.length);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < inventory.length; ++i) {
            NBTTagCompound tag;
            ItemStack stack = inventory[i];
            if (stack != null) {
                tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                tag.func_74757_a("NULLItemStack", false);
                stack.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
                continue;
            }
            tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            tag.func_74757_a("NULLItemStack", true);
            itemList.func_74742_a((NBTBase)tag);
        }
        this.nbt.func_74782_a("Inventory", (NBTBase)itemList);
    }

    @Override
    public void handle(World world, EntityPlayer player) {
        int x = this.nbt.func_74762_e("x");
        int y = this.nbt.func_74762_e("y");
        int z = this.nbt.func_74762_e("z");
        int length = this.nbt.func_74762_e("length");
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileVat || tile instanceof TileAnvil || tile instanceof TileCooling) {
            ItemStack[] inventory = new ItemStack[length];
            IInventory block = (IInventory)world.func_72796_p(x, y, z);
            NBTTagList tagList = this.nbt.func_74761_m("Inventory");
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = (NBTTagCompound)tagList.func_74743_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (tag.func_74767_n("NULLItemStack")) {
                    block.func_70299_a((int)slot, null);
                    continue;
                }
                if (slot < 0 || slot >= inventory.length) continue;
                block.func_70299_a((int)slot, ItemStack.func_77949_a((NBTTagCompound)tag));
            }
        }
        world.func_72902_n(x, y, z);
    }

    @Override
    public void read(DataInputStream is) throws IOException {
        this.nbt = CompressedStreamTools.func_74794_a((DataInput)is);
    }

    @Override
    public void write(DataOutputStream os) throws IOException {
        CompressedStreamTools.func_74800_a((NBTTagCompound)this.nbt, (DataOutput)os);
    }
}

