/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mariculture.core.network.PacketMariculture;
import mariculture.magic.enchantments.EnchantmentFlight;
import mariculture.magic.enchantments.EnchantmentGlide;
import mariculture.magic.enchantments.EnchantmentJump;
import mariculture.magic.enchantments.EnchantmentSpeed;
import mariculture.magic.enchantments.EnchantmentSpider;
import mariculture.magic.enchantments.EnchantmentStepUp;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class Packet111UpdateEnchants
extends PacketMariculture {
    public int speed;
    public int jump;
    public int glide;
    public int flight;
    public int step;
    public boolean spider;

    public Packet111UpdateEnchants() {
    }

    public Packet111UpdateEnchants(int speed, int jump, int glide, int flight, boolean spider, int step) {
        this.speed = speed;
        this.jump = jump;
        this.glide = glide;
        this.flight = flight;
        this.spider = spider;
        this.step = step;
    }

    @Override
    public void handle(World world, EntityPlayer player) {
        EnchantmentSpeed.set(this.speed);
        EnchantmentJump.set(this.jump);
        EnchantmentGlide.set(this.glide);
        EnchantmentFlight.set(this.flight);
        EnchantmentSpider.set(this.spider);
        EnchantmentStepUp.set(this.step, player);
    }

    @Override
    public void read(DataInputStream os) throws IOException {
        this.speed = os.readInt();
        this.jump = os.readInt();
        this.glide = os.readInt();
        this.flight = os.readInt();
        this.spider = os.readBoolean();
        this.step = os.readInt();
    }

    @Override
    public void write(DataOutputStream os) throws IOException {
        os.writeInt(this.speed);
        os.writeInt(this.jump);
        os.writeInt(this.glide);
        os.writeInt(this.flight);
        os.writeBoolean(this.spider);
        os.writeInt(this.step);
    }
}

