/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.lib;

import cofh.api.energy.IEnergyHandler;
import mariculture.factory.Factory;
import mariculture.factory.blocks.TileCustom;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockHalfSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockWall;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PlansMeta {
    public static final int COUNT = 9;
    public static final int FLOOR = 0;
    public static final int BLOCK = 1;
    public static final int STAIRS = 2;
    public static final int SLABS = 3;
    public static final int FENCE = 4;
    public static final int GATE = 5;
    public static final int WALL = 6;
    public static final int LIGHT = 7;
    public static final int RF = 8;

    public static int getType(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.field_77990_d.func_74762_e("type");
        }
        return 0;
    }

    public static ItemStack setType(ItemStack stack, int type) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74768_a("type", type);
        return stack;
    }

    public static ItemStack getBlockStack(int type) {
        switch (type) {
            case 0: {
                return new ItemStack(Factory.customFlooring);
            }
            case 1: {
                return new ItemStack(Factory.customBlock);
            }
            case 2: {
                return new ItemStack(Factory.customStairs);
            }
            case 3: {
                return new ItemStack(Factory.customSlabs);
            }
            case 4: {
                return new ItemStack(Factory.customFence);
            }
            case 5: {
                return new ItemStack(Factory.customGate);
            }
            case 6: {
                return new ItemStack(Factory.customWall);
            }
            case 7: {
                return new ItemStack(Factory.customLight);
            }
            case 8: {
                return new ItemStack(Factory.customRFBlock);
            }
        }
        return null;
    }

    public static int getPlanType(Block block, int id, World world, int x, int y, int z) {
        if (block instanceof BlockFence) {
            return 4;
        }
        if (block instanceof BlockFenceGate) {
            return 5;
        }
        if (block instanceof BlockHalfSlab) {
            return 3;
        }
        if (block instanceof BlockStairs) {
            return 2;
        }
        if (block instanceof BlockWall) {
            return 6;
        }
        if (id == Block.field_111031_cC.field_71990_ca) {
            return 0;
        }
        if ((float)block.getLightValue((IBlockAccess)world, x, y, z) > 0.0f) {
            return 7;
        }
        if (world.func_72796_p(x, y, z) != null && world.func_72796_p(x, y, z) instanceof IEnergyHandler) {
            return 8;
        }
        if (world.func_72796_p(x, y, z) == null && !world.func_72799_c(x, y, z)) {
            return 1;
        }
        return -1;
    }

    public static boolean isSame(ItemStack stack, ItemStack result) {
        if (stack.func_77942_o() && result.func_77942_o()) {
            String name2;
            int[] ids1 = stack.field_77990_d.func_74759_k("BlockIDs");
            int[] ids2 = result.field_77990_d.func_74759_k("BlockIDs");
            int[] meta1 = stack.field_77990_d.func_74759_k("BlockMetas");
            int[] meta2 = result.field_77990_d.func_74759_k("BlockMetas");
            String name1 = stack.field_77990_d.func_74779_i("Name");
            if (name1.equals(name2 = result.field_77990_d.func_74779_i("Name"))) {
                int ids = 0;
                int metas = 0;
                for (int i = 0; i < 6; ++i) {
                    if (ids1[i] == ids2[i]) {
                        ++ids;
                    }
                    if (meta1[i] != meta2[i]) continue;
                    ++metas;
                }
                if (ids == 6 && metas == 6) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isTheSame(World world, int x, int y, int z, ItemStack stack) {
        if (world.func_72796_p(x, y, z) != null && world.func_72796_p(x, y, z) instanceof TileCustom) {
            TileCustom tile = (TileCustom)world.func_72796_p(x, y, z);
            ItemStack ret = new ItemStack(tile.func_70311_o());
            ret.func_77982_d(new NBTTagCompound());
            ret.field_77990_d.func_74783_a("BlockIDs", tile.theBlockIDs());
            ret.field_77990_d.func_74783_a("BlockMetas", tile.theBlockMetas());
            ret.field_77990_d.func_74778_a("Name", tile.name());
            return PlansMeta.isSame(ret, stack);
        }
        return false;
    }
}

