/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.lib;

import java.util.ArrayList;
import java.util.logging.Level;
import mariculture.core.handlers.LogHandler;

public class Modules {
    public static final ArrayList<Module> modules = new ArrayList();
    public static Module core;
    public static Module compat;
    public static Module plugins;
    public static Module aesthetics;
    public static Module diving;
    public static Module factory;
    public static Module fishery;
    public static Module magic;
    public static Module sealife;
    public static Module transport;
    public static Module worldplus;

    public static boolean isActive(Module module) {
        return module != null;
    }

    public void setup(Class<? extends Module> clazz, boolean isActive) {
        if (isActive) {
            try {
                this.getClass().getField(clazz.getSimpleName().toLowerCase()).set(null, clazz.newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static abstract class RegistrationModule
    extends Module {
        public abstract void registerHandlers();

        public abstract void registerBlocks();

        public abstract void registerItems();

        public abstract void registerOther();

        public abstract void registerRecipes();

        @Override
        public void preInit() {
            this.registerHandlers();
            this.registerBlocks();
            this.registerItems();
            this.registerOther();
        }

        @Override
        public void init() {
            this.registerRecipes();
        }

        @Override
        public void postInit() {
            this.setLoaded(null);
        }
    }

    public static abstract class Module {
        public Module() {
            modules.add(this);
        }

        public void setLoaded(String str) {
            LogHandler.log(Level.INFO, this.getClass().getSimpleName() + " Module Finished Loading");
        }

        public abstract void preInit();

        public abstract void init();

        public abstract void postInit();
    }
}

