/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.items;

import mariculture.core.Core;
import mariculture.core.helpers.SpawnItemHelper;
import mariculture.core.items.ItemMariculture;
import mariculture.core.lib.Extra;
import mariculture.core.lib.Modules;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemFood
extends ItemMariculture {
    public ItemFood(int i) {
        super(i);
    }

    private int getFoodLevel(int dmg) {
        switch (dmg) {
            case 0: {
                return 2;
            }
            case 1: {
                return 4;
            }
            case 10: {
                return 3;
            }
            case 2: {
                return 10;
            }
            case 6: {
                return 5;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 8: {
                return 1;
            }
            case 5: {
                return 6;
            }
            case 7: {
                return 4;
            }
            case 11: {
                return 5;
            }
            case 12: {
                return 6;
            }
            case 9: {
                return 20;
            }
        }
        return 1;
    }

    private float getFoodSaturation(int dmg) {
        switch (dmg) {
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 0.85f;
            }
            case 10: {
                return 0.85f;
            }
            case 2: {
                return 1.0f;
            }
            case 6: {
                return 0.6f;
            }
            case 3: {
                return 0.3f;
            }
            case 4: {
                return 0.9f;
            }
            case 8: {
                return 0.1f;
            }
            case 5: {
                return 0.7f;
            }
            case 7: {
                return 1.9f;
            }
            case 11: {
                return 1.1f;
            }
            case 12: {
                return 1.2f;
            }
            case 9: {
                return 5.0f;
            }
        }
        return 0.3f;
    }

    private ItemStack getLeftovers(int meta) {
        switch (meta) {
            case 1: {
                return new ItemStack(Core.food, 1, 10);
            }
            case 10: {
                return new ItemStack(Item.field_77670_E);
            }
            case 3: {
                return new ItemStack(Item.field_77670_E);
            }
            case 4: {
                return new ItemStack(Item.field_77670_E);
            }
            case 7: {
                return new ItemStack(Item.field_77670_E);
            }
            case 11: {
                return new ItemStack(Core.food, 1, 7);
            }
            case 12: {
                return new ItemStack(Core.food, 1, 11);
            }
        }
        return null;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        ItemStack bowl;
        int meta = stack.func_77960_j();
        if (meta == 13) {
            player.func_71024_bL().func_75113_a(100.0f);
            player.func_71024_bL().func_75122_a(-10, 0.0f);
            return stack;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        if ((bowl = this.getLeftovers(meta)) != null && stack.field_77994_a > 0) {
            SpawnItemHelper.addToPlayerInventory(player, bowl);
        }
        int level = this.getFoodLevel(stack.func_77960_j());
        float sat = this.getFoodSaturation(stack.func_77960_j());
        if (Extra.NERF_FOOD) {
            level = (int)Math.max(1.0, (double)level / 2.5);
            sat = Math.max(0.0f, sat / 10.0f);
        }
        player.func_71024_bL().func_75122_a(level, sat);
        world.func_72956_a((Entity)player, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        if (!world.field_72995_K && player.func_70996_bM() && meta == 8) {
            player.func_70691_i(2.0f);
        }
        return bowl != null && stack.field_77994_a == 0 ? bowl : stack;
    }

    public int func_77626_a(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return 16;
            }
            case 4: {
                return 48;
            }
            case 7: {
                return 64;
            }
            case 11: {
                return 64;
            }
            case 12: {
                return 64;
            }
            case 9: {
                return 128;
            }
            case 13: {
                return 4;
            }
        }
        return 32;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.eat;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_71043_e(false) || stack.func_77960_j() == 13) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    @Override
    public int getMetaCount() {
        return 14;
    }

    @Override
    public String getName(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return "fishFinger";
            }
            case 1: {
                return "calamari";
            }
            case 10: {
                return "calamari2";
            }
            case 2: {
                return "smokedSalmon";
            }
            case 6: {
                return "caviar";
            }
            case 3: {
                return "custard";
            }
            case 4: {
                return "fishNCustard";
            }
            case 8: {
                return "kelpWrap";
            }
            case 5: {
                return "sushi";
            }
            case 7: {
                return "misoSoup";
            }
            case 11: {
                return "misoSoup2";
            }
            case 12: {
                return "misoSoup3";
            }
            case 9: {
                return "oyster";
            }
            case 13: {
                return "debug";
            }
        }
        return "food";
    }

    @Override
    public boolean isActive(int meta) {
        if (meta == 9) {
            return true;
        }
        if (meta == 8) {
            return Modules.isActive(Modules.worldplus);
        }
        return Modules.isActive(Modules.fishery);
    }
}

