/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mariculture.api.core.MaricultureRegistry;
import mariculture.api.core.MaricultureTab;
import mariculture.core.Core;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.helpers.cofh.StringHelper;
import mariculture.core.util.IItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class ItemFluidStorage
extends Item
implements IFluidContainerItem,
IItemRegistry {
    public int capacity;
    private Icon filledIcon;

    public ItemFluidStorage(int i, int capacity) {
        super(i);
        this.capacity = capacity;
        this.func_77637_a(MaricultureTab.tabMariculture);
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, true);
        if (movingobjectposition == null) {
            return item;
        }
        if (movingobjectposition.field_72313_a == EnumMovingObjectType.TILE) {
            IFluidContainerItem container = (IFluidContainerItem)item.func_77973_b();
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            int side = movingobjectposition.field_72310_e;
            Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
            if (block instanceof BlockFluidBase || block instanceof BlockFluid) {
                FluidStack fluid = null;
                if (block instanceof BlockFluidBase) {
                    fluid = ((BlockFluidBase)block).drain(world, x, y, z, false);
                }
                if (BlockHelper.isWater(world, x, y, z)) {
                    fluid = FluidRegistry.getFluidStack((String)"water", (int)1000);
                }
                if (BlockHelper.isLava(world, x, y, z)) {
                    fluid = FluidRegistry.getFluidStack((String)"lava", (int)1000);
                }
                if (fluid != null && container.fill(item, fluid, false) >= fluid.amount) {
                    if (block instanceof BlockFluidBase) {
                        ((BlockFluidBase)block).drain(world, x, y, z, true);
                    } else {
                        world.func_94571_i(x, y, z);
                    }
                    container.fill(item, fluid, true);
                    return item;
                }
            }
            if (((IFluidContainerItem)item.func_77973_b()).getFluid(item) != null) {
                FluidStack stack = ((IFluidContainerItem)item.func_77973_b()).getFluid(item);
                Fluid fluid = stack.getFluid();
                if (!fluid.canBePlacedInWorld()) {
                    return item;
                }
                int drain = FluidHelper.getRequiredVolumeForBlock(fluid);
                FluidStack result = ((IFluidContainerItem)item.func_77973_b()).drain(item, drain, false);
                if (result == null || result.amount < drain) {
                    return item;
                }
                if (!result.getFluid().getName().equals("lava") && world.field_73011_w.field_76575_d) {
                    return item;
                }
                int i1 = world.func_72798_a(x, y, z);
                Block aBlock = Block.field_71973_m[i1];
                if (side == 1 && (aBlock instanceof BlockFluidBase || aBlock instanceof BlockFluid)) {
                    --y;
                } else if (i1 == Block.field_72037_aS.field_71990_ca && (world.func_72805_g(x, y, z) & 7) < 1) {
                    side = 1;
                } else if (i1 != Block.field_71998_bu.field_71990_ca && i1 != Block.field_71962_X.field_71990_ca && i1 != Block.field_71961_Y.field_71990_ca) {
                    if (side == 0) {
                        --y;
                    }
                    if (side == 1) {
                        ++y;
                    }
                    if (side == 2) {
                        --z;
                    }
                    if (side == 3) {
                        ++z;
                    }
                    if (side == 4) {
                        --x;
                    }
                    if (side == 5) {
                        ++x;
                    }
                }
                if (!player.func_82247_a(x, y, z, side, item)) {
                    return item;
                }
                if (item.field_77994_a == 0) {
                    return item;
                }
                Block theBlock = Block.field_71973_m[fluid.getBlockID()];
                if (world.func_72832_d(x, y, z, fluid.getBlockID(), 0, 2)) {
                    if (world.func_72798_a(x, y, z) == fluid.getBlockID()) {
                        Block.field_71973_m[fluid.getBlockID()].func_71860_a(world, x, y, z, (EntityLivingBase)player, item);
                        Block.field_71973_m[fluid.getBlockID()].func_85105_g(world, x, y, z, 0);
                    }
                    world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), theBlock.field_72020_cn.func_82593_b(), (theBlock.field_72020_cn.func_72677_b() + 1.0f) / 2.0f, theBlock.field_72020_cn.func_72678_c() * 0.8f);
                    ((IFluidContainerItem)item.func_77973_b()).drain(item, drain, true);
                    return item;
                }
            }
        }
        return item;
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (FluidHelper.isIContainer(item) && world.func_72796_p(x, y, z) instanceof IFluidHandler) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            IFluidHandler tank = (IFluidHandler)world.func_72796_p(x, y, z);
            IFluidContainerItem container = (IFluidContainerItem)item.func_77973_b();
            FluidStack fluid = container.getFluid(item);
            if (fluid != null && fluid.amount > 0) {
                FluidStack stack = container.drain(item, 1000000, false);
                if (stack != null) {
                    stack.amount = tank.fill(dir, stack, false);
                    if (stack.amount > 0) {
                        container.drain(item, stack.amount, true);
                        tank.fill(dir, stack, true);
                        return true;
                    }
                }
            } else {
                FluidStack stack = tank.drain(dir, this.capacity, false);
                if (stack != null && stack.amount > 0) {
                    tank.drain(dir, stack.amount, true);
                    container.fill(item, stack, true);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean shouldPassSneakingClickToBlock(World world, int x, int y, int z) {
        return true;
    }

    public String func_77628_j(ItemStack stack) {
        return "\u00a76" + ("" + StatCollector.func_74838_a((String)(this.func_77657_g(stack) + ".name"))).trim();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        FluidStack fluid = this.getFluid(stack);
        int amount = fluid == null ? 0 : fluid.amount;
        list.add(StringHelper.getFluidName(fluid));
        list.add("" + amount + "/" + this.capacity + "mB");
    }

    public boolean func_77623_v() {
        return true;
    }

    public Icon getIcon(ItemStack stack, int pass) {
        if (stack.field_77993_c == Core.bucket.field_77779_bT) {
            if (pass == 0) {
                if (stack.func_77942_o() && this.getFluid(stack) != null) {
                    FluidStack fake = this.getFluid(stack).copy();
                    fake.amount = Short.MAX_VALUE;
                    ItemStack bucket = FluidContainerRegistry.fillFluidContainer((FluidStack)fake, (ItemStack)new ItemStack(Item.field_77788_aw));
                    if (bucket != null) {
                        return bucket.func_77954_c();
                    }
                }
                return this.field_77791_bV;
            }
            return this.filledIcon;
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("mariculture:" + this.getName(new ItemStack((Item)this)));
        if (this.field_77779_bT == Core.bucket.field_77779_bT) {
            this.filledIcon = iconRegister.func_94245_a("mariculture:" + this.getName(new ItemStack((Item)this)) + "Filled");
        }
    }

    public int getCapacity(ItemStack stack) {
        return this.capacity;
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("Fluid"));
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        int filled;
        if (resource == null) {
            return 0;
        }
        if (!doFill) {
            if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Fluid")) {
                return Math.min(this.capacity, resource.amount);
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("Fluid"));
            if (stack == null) {
                return Math.min(this.capacity, resource.amount);
            }
            if (!stack.isFluidEqual(resource) && stack.amount > 0) {
                return 0;
            }
            return Math.min(this.capacity - stack.amount, resource.amount);
        }
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        if (!container.field_77990_d.func_74764_b("Fluid")) {
            NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
            if (this.capacity < resource.amount) {
                fluidTag.func_74768_a("Amount", this.capacity);
                container.field_77990_d.func_74782_a("Fluid", (NBTBase)fluidTag);
                return this.capacity;
            }
            container.field_77990_d.func_74782_a("Fluid", (NBTBase)fluidTag);
            return resource.amount;
        }
        NBTTagCompound fluidTag = container.field_77990_d.func_74775_l("Fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (!stack.isFluidEqual(resource) && stack.amount > 0) {
            return 0;
        }
        if (!stack.isFluidEqual(resource)) {
            stack.fluidID = resource.fluidID;
        }
        if (resource.amount < (filled = this.capacity - stack.amount)) {
            stack.amount += resource.amount;
            filled = resource.amount;
        } else {
            stack.amount = this.capacity;
        }
        container.field_77990_d.func_74782_a("Fluid", (NBTBase)stack.writeToNBT(fluidTag));
        return filled;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Fluid")) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("Fluid"));
        if (stack == null) {
            return null;
        }
        stack.amount = Math.min(stack.amount, maxDrain);
        if (doDrain) {
            NBTTagCompound fluidTag = container.field_77990_d.func_74775_l("Fluid");
            int newAmount = fluidTag.func_74762_e("Amount") - stack.amount;
            if (newAmount == 0) {
                container.func_77982_d(null);
                return stack;
            }
            fluidTag.func_74768_a("Amount", newAmount);
            container.field_77990_d.func_74782_a("Fluid", (NBTBase)fluidTag);
        }
        return stack;
    }

    @Override
    public void register() {
        MaricultureRegistry.register(this.getName(new ItemStack(this.field_77779_bT, 1, 0)), new ItemStack(this.field_77779_bT, 1, 0));
    }

    @Override
    public int getMetaCount() {
        return 1;
    }

    @Override
    public String getName(ItemStack stack) {
        return this.func_77658_a().substring(5);
    }
}

