/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.items;

import cofh.api.energy.IEnergyContainerItem;
import mariculture.api.core.MaricultureHandlers;
import mariculture.core.helpers.ClientHelper;
import mariculture.core.items.ItemMariculture;
import mariculture.core.lib.Extra;
import mariculture.core.lib.Modules;
import mariculture.core.lib.Text;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemCrafting
extends ItemMariculture
implements IEnergyContainerItem {
    public ItemCrafting(int i) {
        super(i);
    }

    @Override
    public int getMetaCount() {
        return 24;
    }

    @Override
    public String getName(ItemStack stack) {
        String name = "";
        switch (stack.func_77960_j()) {
            case 0: {
                return "goldenSilk";
            }
            case 1: {
                return "goldenThread";
            }
            case 3: {
                return "polishedStick";
            }
            case 4: {
                return "neoprene";
            }
            case 5: {
                return "plastic";
            }
            case 6: {
                return "scubaLens";
            }
            case 7: {
                return "aluminumSheet";
            }
            case 8: {
                return "heater";
            }
            case 9: {
                return "cooler";
            }
            case 10: {
                return "carbide";
            }
            case 11: {
                return "wheel";
            }
            case 12: {
                return "wicker";
            }
            case 13: {
                return "plasticYellow";
            }
            case 15: {
                return "dragonEgg";
            }
            case 2: {
                return "titaniumRod";
            }
            case 16: {
                return "plan_blank";
            }
            case 17: {
                return "chalk";
            }
            case 18: {
                return "titaniumSheet";
            }
            case 19: {
                return "snorkelLens";
            }
            case 14: {
                return "burntBrick";
            }
            case 20: {
                return "titaniumRodBasic";
            }
            case 21: {
                return "lifeCore";
            }
            case 22: {
                return "batteryCreative";
            }
            case 23: {
                return "thermometer";
            }
        }
        return "unnamed";
    }

    public boolean spawnEnderDragon(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return true;
        }
        EntityDragon dragon = new EntityDragon(world);
        dragon.func_70107_b(player.field_70165_t, player.field_70163_u + 10.0, player.field_70161_v);
        world.func_72838_d((Entity)dragon);
        --stack.field_77994_a;
        return true;
    }

    private void displayTemperature(boolean isSneaking, World world, int x, int y, int z) {
        if (world.field_72995_K) {
            String prefix = "";
            int temperature = 0;
            if (isSneaking) {
                prefix = Text.translate("temperature.generic");
                temperature = MaricultureHandlers.environment.getBiomeTemperature(world, x, y, z);
            } else {
                prefix = Text.translate("temperature.precise");
                temperature = MaricultureHandlers.environment.getTemperature(world, x, y, z);
            }
            ClientHelper.addToChat(prefix + ": " + temperature + "\u00b0C");
            ClientHelper.addToChat(Text.translate("environment.salinity") + ": " + Text.translate("salinity." + MaricultureHandlers.environment.getSalinity(world, x, z).name().toLowerCase()));
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        int dmg = stack.func_77960_j();
        if (dmg == 15 && Extra.ENABLE_ENDER_SPAWN) {
            return this.spawnEnderDragon(stack, player, world, x, y, z);
        }
        if (dmg == 23) {
            this.displayTemperature(player.func_70093_af(), world, x, y, z);
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (stack.func_77960_j() == 23) {
            this.displayTemperature(player.func_70093_af(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return stack;
    }

    @Override
    public boolean isActive(int meta) {
        switch (meta) {
            case 15: {
                return Modules.isActive(Modules.fishery);
            }
            case 17: {
                return false;
            }
            case 16: {
                return Modules.isActive(Modules.factory);
            }
            case 3: {
                return Modules.isActive(Modules.fishery);
            }
            case 2: {
                return Modules.isActive(Modules.fishery);
            }
        }
        return true;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return container.func_77960_j() == 22 ? 10000000 : 0;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return 0;
    }
}

